package org.mule.connectivity.restconnect.internal.model.parameter;

import org.apache.commons.lang.StringUtils;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;

public class Parameter {
    private String internalPrefix;
    private String externalName;
    private TypeDefinition typeDefinition;
    private String fixedValue;
    private boolean isPassword;
    private boolean generated;
    private ParameterType parameterType;

    //Indicates if this parameter is duplicated among the full group of parameters this API has.
    //This should only be allowed for parameters of different types (i.e. header & queryParam) in order to disambiguate them
    private boolean duplicatedName;

    public Parameter(String externalName, ParameterType parameterType, TypeDefinition typeDefinition) {
        this.externalName = externalName;
        this.typeDefinition = typeDefinition;
        this.parameterType = parameterType;
    }

    public Parameter(String externalName, ParameterType parameterType, TypeDefinition typeDefinition, boolean password, boolean generated) {
        this.externalName = externalName;
        this.typeDefinition = typeDefinition;
        this.isPassword = password;
        this.generated = generated;
        this.parameterType = parameterType;
    }

    public Parameter(String externalName, ParameterType parameterType, String internalPrefix, TypeDefinition typeDefinition, boolean password){
        this.externalName = externalName;
        this.typeDefinition = typeDefinition;
        this.isPassword = password;
        this.parameterType = parameterType;
        this.internalPrefix = internalPrefix;
    }

    public String getExternalName() {
        return externalName;
    }

    public void setExternalName(String name) {
        this.externalName = name;
    }

    public String getInternalName() {
        String internalName = externalName;

        if (duplicatedName) {
            internalName = parameterType.getName() + externalName;
        }

        if (StringUtils.isNotBlank(internalPrefix)) {
            internalName = internalPrefix + internalName;
        }

        return internalName;
    }

    public TypeDefinition getTypeDefinition() {
        return typeDefinition;
    }

    public String getFixedValue() {
        return fixedValue;
    }

    public void setFixedValue(String fixedValue) {
        this.fixedValue = fixedValue;
    }

    public boolean hasFixedValue() {
        return !StringUtils.isBlank(this.fixedValue);
    }

    public boolean isPassword() {
        return isPassword;
    }

    public boolean isGenerated() {
        return generated;
    }

    public void setPassword(boolean password) {
        isPassword = password;
    }

    public boolean isDuplicatedName() {
        return duplicatedName;
    }

    public void setDuplicatedName(boolean duplicatedExternalName) {
        this.duplicatedName = duplicatedExternalName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Parameter)) return false;

        Parameter parameter = (Parameter) o;

        if (isPassword != parameter.isPassword) return false;
        if (duplicatedName != parameter.duplicatedName) return false;
        if (internalPrefix != null ? !internalPrefix.equals(parameter.internalPrefix) : parameter.internalPrefix != null)
            return false;
        if (externalName != null ? !externalName.equals(parameter.externalName) : parameter.externalName != null)
            return false;
        if (typeDefinition != null ? !typeDefinition.equals(parameter.typeDefinition) : parameter.typeDefinition != null)
            return false;
        if (fixedValue != null ? !fixedValue.equals(parameter.fixedValue) : parameter.fixedValue != null) return false;
        return parameterType == parameter.parameterType;
    }

    @Override
    public int hashCode() {
        int result = internalPrefix != null ? internalPrefix.hashCode() : 0;
        result = 31 * result + (externalName != null ? externalName.hashCode() : 0);
        result = 31 * result + (typeDefinition != null ? typeDefinition.hashCode() : 0);
        result = 31 * result + (fixedValue != null ? fixedValue.hashCode() : 0);
        result = 31 * result + (isPassword ? 1 : 0);
        result = 31 * result + (parameterType != null ? parameterType.hashCode() : 0);
        result = 31 * result + (duplicatedName ? 1 : 0);
        return result;
    }

}
