package org.mule.connectivity.restconnect.internal.model.parameter;

import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinitionBuilder;

public class PartParameter extends Parameter{

    private String partName;
    private String partFilename;
    private String partContentType;

    private String partNameParameterName;
    private String partFilenameParameterName;

    private Parameter partNameParameter = null;
    private Parameter partFilenameParameter = null;

    public PartParameter(String externalName, ParameterType parameterType, TypeDefinition typeDefinition) {
        super(externalName, parameterType, typeDefinition);
    }

    public String getPartName() {
        return partName;
    }

    public void setPartName(String partName) {
        this.partName = partName;
    }

    public String getPartFilename() {
        return partFilename;
    }

    public void setPartFilename(String partFilename) {
        this.partFilename = partFilename;
    }

    public String getPartContentType() {
        return partContentType;
    }

    public void setPartContentType(String partContentType) {
        this.partContentType = partContentType;
    }

    public void setPartNameParameterName(String partNameParameterName) {
        this.partNameParameterName = partNameParameterName;
    }

    public void setPartFilenameParameterName(String partFilenameParameterName) {
        this.partFilenameParameterName = partFilenameParameterName;
    }

    public Parameter getPartNameParameter() {
        if(partNameParameter == null && StringUtils.isNotBlank(partNameParameterName)){
            partNameParameter = new Parameter(partNameParameterName, ParameterType.PART_PROPERTY, TypeDefinitionBuilder.buildSimpleStringType(true));
        }

        return partNameParameter;
    }

    public Parameter getPartFilenameParameter() {
        if(partFilenameParameter == null && StringUtils.isNotBlank(partFilenameParameterName)){
            partFilenameParameter = new Parameter(partFilenameParameterName, ParameterType.PART_PROPERTY, TypeDefinitionBuilder.buildSimpleStringType(true));
        }

        return partFilenameParameter;
    }
}
