package org.mule.connectivity.restconnect.internal.model.security;

import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;

import java.util.Arrays;

public class DigestAuthenticationScheme extends APISecurityScheme {


    public DigestAuthenticationScheme(){
        super();
    }

    @Override
    public String getSchemeName() {
        return DIGEST_AUTHENTICATION;
    }

    @Override
    public void initializeConfigParameters() {
        configParameters = Arrays.asList(
                getSecuritySchemeParameter("username", "username", PrimitiveTypeSource.PrimitiveType.STRING, "Username", null, null,true, false),
                getSecuritySchemeParameter("password", "password", PrimitiveTypeSource.PrimitiveType.STRING, "Password", null, null,true, true)
        );
    }

    @Override
    protected boolean equalProperties(APISecurityScheme scheme) {
        return scheme instanceof DigestAuthenticationScheme;
    }
}
