package org.mule.connectivity.restconnect.internal.model.security;

import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;

import java.util.List;

public class JwtAuthenticationScheme extends APISecurityScheme {

    public JwtAuthenticationScheme(List<Parameter> jwtHeaders, List<Parameter> jwtBody, List<Parameter> accessTokenRequestParameters) {
        this.headers.addAll(jwtHeaders);
        this.configParameters.addAll(jwtBody);
        this.queryParameters.addAll(accessTokenRequestParameters);
    }

    @Override
    public String getSchemeName() {
        return JWT;
    }

    @Override
    public void initializeConfigParameters() {
    }

    @Override
    protected boolean equalProperties(APISecurityScheme scheme) {
        return false;
    }
}
