package org.mule.connectivity.restconnect.internal.modelGeneration.amf;

import static org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource.PrimitiveType.BOOLEAN;
import static org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource.PrimitiveType.DATE_ONLY;
import static org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource.PrimitiveType.DATE_TIME;
import static org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource.PrimitiveType.DATE_TIME_ONLY;
import static org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource.PrimitiveType.FILE;
import static org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource.PrimitiveType.INTEGER;
import static org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource.PrimitiveType.NUMBER;
import static org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource.PrimitiveType.STRING;
import static org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource.PrimitiveType.TIME_ONLY;

import amf.core.client.platform.model.domain.Shape;
import amf.shapes.client.platform.model.domain.FileShape;
import amf.shapes.client.platform.model.domain.ScalarShape;

import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;
import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource.PrimitiveType;

import java.util.HashMap;
import java.util.Map;

public class PrimitiveMetadataModelFactory {

    // Private constructor to prevent instantiation.
    private PrimitiveMetadataModelFactory() {

    }

    private static final Map<String, PrimitiveType> scalarTypeMappings = new HashMap<>();
    static {
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#boolean", BOOLEAN);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#float", NUMBER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#double", NUMBER);
        scalarTypeMappings.put("http://a.ml/vocabularies/shapes#number", NUMBER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#integer", INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#long", INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#byte", INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#short", INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedByte", INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedInt", INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedLong", INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedShort", INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#nonNegativeInteger", INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#positiveInteger", INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#nonPositiveInteger", INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#negativeInteger", INTEGER);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#string", STRING);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#base64Binary", STRING);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#hexBinary", STRING);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#token", STRING);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#dateTime", DATE_TIME);
        scalarTypeMappings.put("http://a.ml/vocabularies/shapes#dateTimeOnly", DATE_TIME_ONLY);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#date", DATE_ONLY);
        scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#time", TIME_ONLY);
    }

    public static PrimitiveTypeSource createPrimitiveMetadataModel(Shape shape) {

        PrimitiveType primitiveType = null;

        if (shape instanceof ScalarShape) {
            primitiveType = scalarTypeMappings.get(((ScalarShape) shape).dataType().value());
        }

        else if (shape instanceof FileShape) {
            primitiveType = FILE;
        }

        return new PrimitiveTypeSource(primitiveType);
    }

}
