package org.mule.connectivity.restconnect.internal.templateEngine;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class SmartConnectorGeneratedSources {
    private Path outputDir;

    private Path pom;
    private Path catalog;
    private Path module;
    private Path artifact;
    private Path icon;
    private List<Path> catalogSchemas = new ArrayList<>();
    private List<Path> complementaryXmlSchemas = new ArrayList<>();


    public SmartConnectorGeneratedSources(Path outputDir){
        this.outputDir = outputDir;
    }

    public Path getOutputDir() {
        return outputDir;
    }

    public void setOutputDir(Path outputDir) {
        this.outputDir = outputDir;
    }

    public Path getPom() {
        return pom;
    }

    public void setPom(Path pom) {
        this.pom = pom;
    }

    public Path getCatalog() {
        return catalog;
    }

    public void setCatalog(Path catalog) {
        this.catalog = catalog;
    }

    public Path getModule() {
        return module;
    }

    public void setModule(Path module) {
        this.module = module;
    }

    public Path getArtifact() {
        return artifact;
    }

    public void setArtifact(Path artifact) {
        this.artifact = artifact;
    }

    public Path getIcon() {
        return icon;
    }

    public void setIcon(Path icon) {
        this.icon = icon;
    }

    public void addCatalogSchema(Path catalogSchema) {
        catalogSchemas.add(catalogSchema);
    }

    public void addComplementaryXmlSchema(Path complementaryXmlSchema){
        complementaryXmlSchemas.add(complementaryXmlSchema);
    }

    public List<Path> getDistinctCatalogSchemas() {
        return getDistinctPaths(catalogSchemas);
    }

    public List<Path> getDistinctComplementaryXmlSchemas() {
        return getDistinctPaths(complementaryXmlSchemas);
    }

    private List<Path> getDistinctPaths(List<Path> paths) {
        List<Path> distinctPaths = new ArrayList<>();
        for (Path path : paths){
            boolean add = true;
            for (Path addedPath : distinctPaths){
                if(addedPath.toAbsolutePath().toString().equals(path.toAbsolutePath().toString())){
                    add = false;
                    break;
                }
            }

            if(add){
                distinctPaths.add(path.toAbsolutePath());
            }
        }
        return distinctPaths;
    }

    public void setCatalogSchemas(List<Path> catalogSchemas) {
        this.catalogSchemas = catalogSchemas;
    }
}
