package org.mule.connectivity.restconnect.internal.util;

import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;

import java.io.File;
import java.io.IOException;
import java.util.Date;

import static com.google.common.io.Files.createTempDir;
import static org.apache.commons.io.FileUtils.writeStringToFile;

public class FileUtils {

    // Overrides default construction to avoiding instantiation.
    private FileUtils() {

    }

    public static File createTempFile(String content) throws IOException {
        File file = File.createTempFile(getTempName(), ".tmp");
        writeStringToFile(file, content);
        file.deleteOnExit();
        return file;
    }

    private static String getTempName() {
        return String.valueOf(new Date().getTime());
    }

    public static File unzipFile(File file) throws ZipException {
        File dir = createTempDir();
        ZipFile zipFile = new ZipFile(file);
        zipFile.extractAll(dir.getPath());
        return dir;
    }

}
