/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.operation;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinitionBuilder;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.ParserUtils;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.SmartConnectorModelDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.model.SmartConnectorSecuritySchemeHelper;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.operation.OperationDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorSecuritySchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorSecuritySchemeDecoratorFactory;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.type.SmartConnectorTypeDefinitionDecorator;
import org.mule.connectivity.restconnect.internal.util.DataWeaveUtils;

public class SmartConnectorOperationDecorator
extends OperationDecorator {
    private final SmartConnectorTypeDefinitionDecorator outputMetadata;
    private final SmartConnectorTypeDefinitionDecorator inputMetadata = this.buildInputMetadata();
    private final List<SmartConnectorTypeDefinitionDecorator> parameters;
    private final SmartConnectorSecuritySchemeDecorator prioritarySecuritySchemeDecorator;
    private final List<SmartConnectorSecuritySchemeDecorator> allSecuritySchemesDecorators;
    private String allSecuritySchemesFilename;

    public SmartConnectorOperationDecorator(Operation operation, HashMap<APISecurityScheme, String> securitySchemesNames, HashMap<String, SmartConnectorTypeDefinitionDecorator> allTypeDecorators, SmartConnectorModelDecorator smartConnectorModelDecorator) {
        super(operation, smartConnectorModelDecorator);
        this.outputMetadata = this.buildOutputMetadata();
        this.parameters = SmartConnectorOperationDecorator.buildDecoratedParameters(this.getParameters(), allTypeDecorators);
        if (operation.isUserSelectedSecuritySchemes() && operation.getSecuritySchemes().size() > 1) {
            this.allSecuritySchemesDecorators = SmartConnectorOperationDecorator.buildDecoratedSecuritySchemes(operation, securitySchemesNames);
            this.prioritarySecuritySchemeDecorator = null;
        } else {
            this.prioritarySecuritySchemeDecorator = SmartConnectorOperationDecorator.buildDecoratedPrioritarySecurityScheme(operation, securitySchemesNames);
            this.allSecuritySchemesDecorators = null;
        }
    }

    public static List<SmartConnectorTypeDefinitionDecorator> buildDecoratedParameters(List<Parameter> parameters, HashMap<String, SmartConnectorTypeDefinitionDecorator> allTypeDecorators) {
        return SmartConnectorOperationDecorator.buildDecoratedParameters(parameters, "", allTypeDecorators);
    }

    public static List<SmartConnectorTypeDefinitionDecorator> buildDecoratedParameters(List<Parameter> parameters, String namePrefix, HashMap<String, SmartConnectorTypeDefinitionDecorator> allTypeDecorators) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Parameter param : parameters) {
            String typeName;
            SmartConnectorTypeDefinitionDecorator smartConnectorTypeDefinitionDecorator = SmartConnectorOperationDecorator.buildDecoratedParameter(param, namePrefix);
            builder.add((Object)smartConnectorTypeDefinitionDecorator);
            if (!smartConnectorTypeDefinitionDecorator.requiresCatalog() || allTypeDecorators.containsKey(typeName = smartConnectorTypeDefinitionDecorator.getType())) continue;
            allTypeDecorators.put(typeName, smartConnectorTypeDefinitionDecorator);
        }
        return builder.build();
    }

    public static SmartConnectorTypeDefinitionDecorator buildDecoratedParameter(Parameter param, String namePrefix) {
        String prefix = !namePrefix.isEmpty() ? namePrefix + "-" : "";
        String internalName = prefix + param.getInternalName();
        if (ParserUtils.isReservedMuleKeyword(param.getInternalName())) {
            internalName = "sc-" + internalName;
        }
        return new SmartConnectorTypeDefinitionDecorator(prefix + param.getExternalName(), internalName, param.getTypeDefinition(), param.isPassword());
    }

    protected static SmartConnectorSecuritySchemeDecorator buildDecoratedPrioritarySecurityScheme(Operation operation, HashMap<APISecurityScheme, String> securitySchemesNames) {
        return SmartConnectorSecuritySchemeDecoratorFactory.getSecuritySchemeDecorator(SmartConnectorSecuritySchemeHelper.getPrioritarySecurityScheme(operation.getSecuritySchemes()), securitySchemesNames);
    }

    protected static List<SmartConnectorSecuritySchemeDecorator> buildDecoratedSecuritySchemes(Operation operation, HashMap<APISecurityScheme, String> securitySchemesNames) {
        return operation.getSecuritySchemes().stream().map(x -> SmartConnectorSecuritySchemeDecoratorFactory.getSecuritySchemeDecorator(x, securitySchemesNames)).collect(Collectors.toList());
    }

    private SmartConnectorTypeDefinitionDecorator buildOutputMetadata() {
        if (this.getOutputMetadata() == null) {
            return null;
        }
        SmartConnectorTypeDefinitionDecorator outputMetadata = new SmartConnectorTypeDefinitionDecorator(this.getOutputMetadata());
        outputMetadata.setName(this.getName() + "-response-data");
        outputMetadata.setType(this.getName() + "-response-type");
        return outputMetadata;
    }

    private SmartConnectorTypeDefinitionDecorator buildInputMetadata() {
        if (this.getInputMetadata() == null) {
            return null;
        }
        SmartConnectorTypeDefinitionDecorator inputMetadata = new SmartConnectorTypeDefinitionDecorator(this.getInputMetadata());
        inputMetadata.setName(this.getName() + "-request-data");
        inputMetadata.setType(this.getName() + "-request-type");
        return inputMetadata;
    }

    @Override
    public List<Parameter> getHeaders() {
        List<Parameter> baseHeaders = this.operation.getHeaders();
        boolean hasAcceptHeader = false;
        for (Parameter param : baseHeaders) {
            if (!param.getExternalName().equalsIgnoreCase("accept")) continue;
            hasAcceptHeader = true;
        }
        if (!hasAcceptHeader && this.outputMetadata != null && this.outputMetadata.hasMediaType()) {
            LinkedList<Parameter> headers = new LinkedList<Parameter>();
            Parameter fixedValueHeader = new Parameter("Accept", ParameterType.HEADER, TypeDefinitionBuilder.buildHeaderType());
            fixedValueHeader.setFixedValue(this.outputMetadata.getMediaType());
            headers.add(fixedValueHeader);
            headers.addAll(baseHeaders);
            return headers;
        }
        return baseHeaders;
    }

    public String getName() {
        return ParserUtils.getXmlName(this.getCanonicalName());
    }

    public SmartConnectorTypeDefinitionDecorator getDecoratedInputMetadata() {
        return this.inputMetadata;
    }

    public SmartConnectorTypeDefinitionDecorator getDecoratedOutputMetadata() {
        return this.outputMetadata;
    }

    public List<SmartConnectorTypeDefinitionDecorator> getDecoratedParameters() {
        return this.parameters;
    }

    public String getQueryParametersDW() {
        return DataWeaveUtils.getParametersDW(this.getQueryParameters(), null);
    }

    public String getUriParametersDW() {
        return DataWeaveUtils.getParametersDW(this.getUriParameters(), null);
    }

    public String getHeadersDW() {
        return DataWeaveUtils.getParametersDW(this.getHeaders(), null);
    }

    public boolean hasInputParameters() {
        return this.getInputMetadata() != null || !this.getParameters().isEmpty();
    }

    public SmartConnectorSecuritySchemeDecorator getSecurityScheme() {
        return this.prioritarySecuritySchemeDecorator;
    }

    public boolean isUserSelectedSecuritySchemes() {
        if (this.operation.getSecuritySchemes().size() > 1) {
            return this.operation.isUserSelectedSecuritySchemes();
        }
        return false;
    }

    public List<SmartConnectorSecuritySchemeDecorator> getAllSecuritySchemes() {
        return this.allSecuritySchemesDecorators;
    }

    private List<String> getAllSecuritySchemesNames() {
        LinkedList<String> names = new LinkedList<String>();
        for (SmartConnectorSecuritySchemeDecorator ss : this.getAllSecuritySchemes()) {
            names.add(ss.getFriendlyName());
        }
        return names;
    }

    public String getAllSecuritySchemesNamesEnum() {
        return "\"" + String.join((CharSequence)"\",\"", this.getAllSecuritySchemesNames()) + "\"";
    }

    public void setAllSecuritySchemesFilename(String allSecuritySchemesFilename) {
        this.allSecuritySchemesFilename = allSecuritySchemesFilename;
    }

    public String getAllSecuritySchemesFilename() {
        return this.allSecuritySchemesFilename;
    }
}

