/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.model.HTTPMethod;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.operation.OperationBuilder;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinitionBuilder;
import org.mule.connectivity.restconnect.internal.modelGeneration.JsonSchemaPool;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.RamlParserTypeDefinitionFactory;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.security.RamlParserSecuritySchemeFactory;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.util.RamlParserUtils;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;

public class RamlParserOperationGenerator {
    public static Operation generateOperation(Api api, Method method, JsonSchemaPool jsonSchemaPool) throws Exception {
        RamlParserTypeDefinitionFactory typeDefinitionFactory = new RamlParserTypeDefinitionFactory(method, jsonSchemaPool);
        String friendlyName = RamlParserUtils.getMethodDisplayName(method);
        String annotatedName = RamlParserUtils.getAnnotatedOperationName(method);
        Operation operation = new OperationBuilder().withFriendlyName(friendlyName).withAnnotatedDisplayName(StringUtils.isNotBlank((CharSequence)annotatedName) ? annotatedName : friendlyName).withCanonicalName(RamlParserUtils.getCanonicalOperationName(method, RamlParserUtils.getMethodDisplayName(method))).withDescription(RamlParserUtils.getMethodDescription(method)).withHttpMethod(HTTPMethod.fromString(method.method())).withUri(method.resource().resourcePath()).withUriParams(RamlParserOperationGenerator.buildUriParams(method, jsonSchemaPool)).withQueryParams(RamlParserOperationGenerator.buildQueryParams(method, jsonSchemaPool)).withHeaders(RamlParserOperationGenerator.buildHeaders(method, jsonSchemaPool)).withInputMetadata(typeDefinitionFactory.constructInputMetadata()).withOutputMetadata(typeDefinitionFactory.constructOutputMetadata()).withSecuritySchemes(RamlParserOperationGenerator.buildSecuritySchemes(api, method, jsonSchemaPool)).withUserSelectedSecuritySchemes(RamlParserUtils.isGenerateUserSelectedSecuritySchemes(method, api)).build();
        return operation;
    }

    private static List<APISecurityScheme> buildSecuritySchemes(Api api, Method method, JsonSchemaPool jsonSchemaPool) throws Exception {
        return RamlParserSecuritySchemeFactory.getOperationSecuritySchemes(api, method, jsonSchemaPool);
    }

    private static List<Parameter> buildQueryParams(Method method, JsonSchemaPool jsonSchemaPool) throws Exception {
        if (method.queryString() != null) {
            return RamlParserOperationGenerator.buildQueryParametersFromQueryString(method);
        }
        return RamlParserUtils.getParameterList(method.queryParameters(), ParameterType.QUERY, jsonSchemaPool);
    }

    private static List<Parameter> buildQueryParametersFromQueryString(Method method) {
        HashSet parameters = new HashSet();
        if (method.queryString() instanceof ObjectTypeDeclaration) {
            ((ObjectTypeDeclaration)method.queryString()).properties().stream().forEach(p -> parameters.add(p.name()));
        } else if (method.queryString() instanceof UnionTypeDeclaration) {
            ((UnionTypeDeclaration)method.queryString()).of().stream().forEach(typeDeclaration -> ((ObjectTypeDeclaration)typeDeclaration).properties().stream().forEach(p -> parameters.add(p.name())));
        }
        return new ArrayList(parameters).stream().map(p -> new Parameter((String)p, ParameterType.QUERY, TypeDefinitionBuilder.buildSimpleStringType(false))).collect(Collectors.toList());
    }

    private static List<Parameter> buildUriParams(Method method, JsonSchemaPool jsonSchemaPool) throws Exception {
        ArrayList<Parameter> uriParameters = new ArrayList<Parameter>();
        for (Resource resource = method.resource(); resource != null; resource = resource.parentResource()) {
            for (Parameter uriParam : RamlParserUtils.getParameterList(resource.uriParameters(), ParameterType.URI, jsonSchemaPool)) {
                if (!uriParameters.stream().noneMatch(y -> y.getExternalName().equalsIgnoreCase(uriParam.getExternalName()))) continue;
                uriParameters.add(0, uriParam);
            }
        }
        return uriParameters;
    }

    private static List<Parameter> buildHeaders(Method method, JsonSchemaPool jsonSchemaPool) throws Exception {
        return RamlParserUtils.getParameterList(method.headers(), ParameterType.HEADER, jsonSchemaPool);
    }
}

