/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.security.OAuth2Scheme;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorPomDependency;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorSecuritySchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorXMLConfig;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorXMLSchema;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorXMLSchemaLocation;

public class SmartConnectorOAuth2SchemeDecorator
extends SmartConnectorSecuritySchemeDecorator {
    private final String grant;
    private final boolean hasScopes;
    private final String refreshTokenWhen;

    public SmartConnectorOAuth2SchemeDecorator(APISecurityScheme securityScheme, HashMap<APISecurityScheme, String> securitySchemesNames, boolean tlsEnabled) {
        super(securityScheme, securitySchemesNames, tlsEnabled);
        OAuth2Scheme oAuth2Scheme = (OAuth2Scheme)securityScheme;
        this.grant = oAuth2Scheme.getAuthorizationGrants().get(0);
        this.hasScopes = oAuth2Scheme.getScopes().size() > 0;
        this.refreshTokenWhen = oAuth2Scheme.getRenewTokenExpression();
    }

    @Override
    protected List<SmartConnectorXMLSchemaLocation> buildXmlSchemaLocations() {
        LinkedList<SmartConnectorXMLSchemaLocation> xmlSchemaLocations = new LinkedList<SmartConnectorXMLSchemaLocation>();
        xmlSchemaLocations.add(SmartConnectorXMLSchemaLocation.OAUTH);
        return xmlSchemaLocations;
    }

    @Override
    protected List<SmartConnectorXMLSchema> buildXmlSchemas() {
        LinkedList<SmartConnectorXMLSchema> xmlSchemas = new LinkedList<SmartConnectorXMLSchema>();
        xmlSchemas.add(SmartConnectorXMLSchema.OAUTH);
        return xmlSchemas;
    }

    @Override
    protected List<SmartConnectorXMLConfig> buildXmlConfigs() {
        LinkedList<SmartConnectorXMLConfig> xmlConfigs = new LinkedList<SmartConnectorXMLConfig>();
        xmlConfigs.add(SmartConnectorXMLConfig.TOKEN_MANAGER);
        return xmlConfigs;
    }

    @Override
    protected List<SmartConnectorPomDependency> buildPomDependencies() {
        LinkedList<SmartConnectorPomDependency> pomDependencies = new LinkedList<SmartConnectorPomDependency>();
        pomDependencies.add(SmartConnectorPomDependency.OAUTH);
        return pomDependencies;
    }

    @Override
    public String getHttpAuthorizationConfigString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<http:authentication>").append(System.lineSeparator());
        if (this.grant.equalsIgnoreCase("client_credentials")) {
            builder.append("<oauth:client-credentials-grant-type").append(System.lineSeparator());
        } else if (this.grant.equalsIgnoreCase("authorization_code")) {
            builder.append("<oauth:authorization-code-grant-type").append(System.lineSeparator());
        }
        builder.append(this.getConfigLineForProperty("clientId", "clientId"));
        builder.append(this.getConfigLineForProperty("clientSecret", "clientSecret"));
        builder.append(this.getConfigLineForProperty("accessTokenUrl", "tokenUrl"));
        if (this.hasScopes) {
            builder.append(this.getConfigLineForProperty("scopes", "scopes"));
        }
        if (this.grant.equalsIgnoreCase("authorization_code")) {
            builder.append(this.getConfigLineForProperty("localCallbackConfig", "localCallbackConfig"));
            builder.append(this.getConfigLineForProperty("localCallbackPath", "localCallbackConfigPath"));
            builder.append(this.getConfigLineForProperty("externalCallbackUrl", "externalCallbackUrl"));
            builder.append(this.getConfigLineForProperty("localAuthorizationUrl", "localAuthorizationUrl"));
            builder.append(this.getConfigLineForProperty("authorizationUrl", "authorizationUrl"));
        }
        builder.append("tokenManager=\"tokenManagerConfig\" refreshTokenWhen=\"").append(this.refreshTokenWhen).append("\">").append(System.lineSeparator());
        if (this.grant.equalsIgnoreCase("client_credentials")) {
            builder.append("</oauth:client-credentials-grant-type>").append(System.lineSeparator());
        } else if (this.grant.equalsIgnoreCase("authorization_code")) {
            builder.append("</oauth:authorization-code-grant-type>").append(System.lineSeparator());
        }
        builder.append("</http:authentication>").append(System.lineSeparator());
        return builder.toString();
    }
}

