package org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector;

import static java.lang.System.lineSeparator;
import static org.mule.connectivity.restconnect.internal.model.security.OAuth2Scheme.OAUTH2_GRANT_AUTHORIZATION_CODE;
import static org.mule.connectivity.restconnect.internal.model.security.OAuth2Scheme.OAUTH2_GRANT_CLIENT_CREDENTIALS;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.security.OAuth2Scheme;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class SmartConnectorOAuth2SchemeDecorator extends SmartConnectorSecuritySchemeDecorator {

    private final String grant;
    private final boolean hasScopes;
    private final String refreshTokenWhen;

    public SmartConnectorOAuth2SchemeDecorator(APISecurityScheme securityScheme, HashMap<APISecurityScheme, String> securitySchemesNames, boolean tlsEnabled) {
        super(securityScheme, securitySchemesNames, tlsEnabled);
        OAuth2Scheme oAuth2Scheme = (OAuth2Scheme) securityScheme;

        grant = oAuth2Scheme.getAuthorizationGrants().get(0);
        hasScopes = oAuth2Scheme.getScopes().size() > 0;
        refreshTokenWhen = oAuth2Scheme.getRenewTokenExpression();
    }

    @Override
    protected List<SmartConnectorXMLSchemaLocation> buildXmlSchemaLocations() {
        List<SmartConnectorXMLSchemaLocation> xmlSchemaLocations = new LinkedList<>();
        xmlSchemaLocations.add(SmartConnectorXMLSchemaLocation.OAUTH);
        return xmlSchemaLocations;
    }

    @Override
    protected List<SmartConnectorXMLSchema> buildXmlSchemas() {
        List<SmartConnectorXMLSchema> xmlSchemas = new LinkedList<>();
        xmlSchemas.add(SmartConnectorXMLSchema.OAUTH);
        return xmlSchemas;
    }

    @Override
    protected List<SmartConnectorXMLConfig> buildXmlConfigs() {
        List<SmartConnectorXMLConfig> xmlConfigs = new LinkedList<>();
        xmlConfigs.add(SmartConnectorXMLConfig.TOKEN_MANAGER);
        return xmlConfigs;
    }

    @Override
    protected List<SmartConnectorPomDependency> buildPomDependencies() {
        List<SmartConnectorPomDependency> pomDependencies = new LinkedList<>();
        pomDependencies.add(SmartConnectorPomDependency.OAUTH);
        return pomDependencies;
    }

    @Override
    public String getHttpAuthorizationConfigString() {
        StringBuilder builder = new StringBuilder();

        builder.append("<http:authentication>").append(lineSeparator());
        if(grant.equalsIgnoreCase(OAUTH2_GRANT_CLIENT_CREDENTIALS)){
            builder.append("<oauth:client-credentials-grant-type").append(lineSeparator());
        }
        else if(grant.equalsIgnoreCase(OAUTH2_GRANT_AUTHORIZATION_CODE)){
            builder.append("<oauth:authorization-code-grant-type").append(lineSeparator());
        }

        builder.append(getConfigLineForProperty("clientId", "clientId"));
        builder.append(getConfigLineForProperty("clientSecret", "clientSecret"));
        builder.append(getConfigLineForProperty("accessTokenUrl", "tokenUrl"));

        if(hasScopes){
            builder.append(getConfigLineForProperty("scopes", "scopes"));
        }

        if(grant.equalsIgnoreCase(OAUTH2_GRANT_AUTHORIZATION_CODE)){
            builder.append(getConfigLineForProperty("localCallbackConfig", "localCallbackConfig"));
            builder.append(getConfigLineForProperty("localCallbackPath", "localCallbackConfigPath"));
            builder.append(getConfigLineForProperty("externalCallbackUrl", "externalCallbackUrl"));
            builder.append(getConfigLineForProperty("localAuthorizationUrl", "localAuthorizationUrl"));
            builder.append(getConfigLineForProperty("authorizationUrl", "authorizationUrl"));
        }

        builder
            .append("tokenManager=\"tokenManagerConfig\" refreshTokenWhen=\"")
            .append(refreshTokenWhen)
            .append("\">")
            .append(lineSeparator());

        if(grant.equalsIgnoreCase(OAUTH2_GRANT_CLIENT_CREDENTIALS)){
            builder.append("</oauth:client-credentials-grant-type>").append(lineSeparator());
        }
        else if(grant.equalsIgnoreCase(OAUTH2_GRANT_AUTHORIZATION_CODE)){
            builder.append("</oauth:authorization-code-grant-type>").append(lineSeparator());
        }

        builder.append("</http:authentication>").append(lineSeparator());

        return builder.toString();
    }
}
