package org.mule.connectivity.restconnect.internal.modelGeneration.util;

import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

import static java.lang.String.format;


public class OperationMappingUtils {

    /* Avoid instantiation*/
    protected OperationMappingUtils(){

    }

    protected final static Logger logger = LoggerFactory.getLogger(OperationMappingUtils.class);

    /**
     * Renames the operations that have names that repeat appending a numbered suffix:
     *      - GET_STREET    ->  GET_STREET_1
     *      - GET_STREET    ->  GET_STREET_2
     *      - GET_STREET    ->  GET_STREET_3
     *      etc.
     *
     */
    public static void disambiguateRepeatedOperations(List<? extends Operation> operations) {
        // This set contains only the repeated names.
        Set<String> repeatedNames = new HashSet<>();

        // This map is used so that operations have an increasing number according to the position on the RAML.
        Map<String, Integer> replacedNames = new HashMap<>();

        for (Operation operation : operations) {
            String name = operation.getCanonicalName();

            if (replacedNames.containsKey(name)) {
                repeatedNames.add(name);
            }

            else {
                replacedNames.put(name, 0);
            }
        }

        // Appends a suffix to repeated operations.
        for (Operation operation : operations) {
            String operationName = operation.getCanonicalName();

            if (!repeatedNames.contains(operationName))
                continue;

            int occurrences = replacedNames.get(operationName) + 1;
            operation.setCanonicalName(format("%s_%d", operationName, occurrences));
            replacedNames.put(operationName, occurrences);
        }
    }

}
