package org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.devkit;

import org.mule.connectivity.restconnect.internal.model.security.*;
import org.mule.connectivity.restconnect.internal.templateEngine.PojoFQNamePool;

import java.util.Map;

public class DevKitSecuritySchemeDecoratorFactory {
    public static DevKitSecuritySchemeDecorator getSecuritySchemeDecorator(APISecurityScheme scheme, Map<APISecurityScheme, String> securitySchemesNames, PojoFQNamePool pojoFQNamePool){
        if(scheme instanceof OAuth2ClientCredentialsScheme){
            return new DevKitOAuth2ClientCredentialsSchemeDecorator(scheme, securitySchemesNames);
        }
        else if(scheme instanceof OAuth2AuthorizationCodeScheme){
            return new DevKitOAuth2AuthorizationCodeSchemeDecorator(scheme, securitySchemesNames);
        }
        else if(scheme instanceof PassThroughScheme){
            return new DevKitPassThroughSchemeDecorator(scheme, securitySchemesNames, pojoFQNamePool);
        }
        else if(scheme instanceof CustomAuthenticationScheme){
            return new DevKitCustomAuthenticationSchemeDecorator(scheme, securitySchemesNames, pojoFQNamePool);
        }
        else if(scheme instanceof UnsecuredScheme){
            return new DevKitUnsecuredSchemeSchemeDecorator(scheme, securitySchemesNames);
        }
        else if(scheme instanceof BasicAuthScheme){
            return new DevKitBasicAuthSchemeDecorator(scheme, securitySchemesNames);
        }
        else if(scheme instanceof DigestAuthenticationScheme){
            return new DevKitDigestAuthenticationSchemeDecorator(scheme, securitySchemesNames);
        }
        else {
            throw new IllegalArgumentException("Auth scheme not supported. Should not reach this place.");
        }
    }
}
