/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector;

import java.util.HashMap;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.security.BasicAuthScheme;
import org.mule.connectivity.restconnect.internal.model.security.CustomAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.model.security.DigestAuthenticationScheme;
import org.mule.connectivity.restconnect.internal.model.security.OAuth2Scheme;
import org.mule.connectivity.restconnect.internal.model.security.PassThroughScheme;
import org.mule.connectivity.restconnect.internal.model.security.UnsecuredScheme;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorBasicAuthSchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorCustomSchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorDigestSchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorOAuth2SchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorPassThroughSchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorSecuritySchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorUnsecuredSchemeDecorator;

public class SmartConnectorSecuritySchemeDecoratorFactory {
    public static SmartConnectorSecuritySchemeDecorator getSecuritySchemeDecorator(APISecurityScheme scheme, HashMap<APISecurityScheme, String> securitySchemesNames, boolean tlsEnabled) {
        if (scheme instanceof OAuth2Scheme) {
            return new SmartConnectorOAuth2SchemeDecorator(scheme, securitySchemesNames, tlsEnabled);
        }
        if (scheme instanceof PassThroughScheme) {
            return new SmartConnectorPassThroughSchemeDecorator(scheme, securitySchemesNames, tlsEnabled);
        }
        if (scheme instanceof CustomAuthenticationScheme) {
            return new SmartConnectorCustomSchemeDecorator(scheme, securitySchemesNames, tlsEnabled);
        }
        if (scheme instanceof UnsecuredScheme) {
            return new SmartConnectorUnsecuredSchemeDecorator(scheme, securitySchemesNames, tlsEnabled);
        }
        if (scheme instanceof BasicAuthScheme) {
            return new SmartConnectorBasicAuthSchemeDecorator(scheme, securitySchemesNames, tlsEnabled);
        }
        if (scheme instanceof DigestAuthenticationScheme) {
            return new SmartConnectorDigestSchemeDecorator(scheme, securitySchemesNames, tlsEnabled);
        }
        throw new IllegalArgumentException("Auth scheme not supported. Should not reach here.");
    }
}

