/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.model.api;

import java.nio.file.Path;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.connectivity.restconnect.internal.model.ConnectorCategory;
import org.mule.connectivity.restconnect.internal.model.MavenDependency;
import org.mule.connectivity.restconnect.internal.model.api.RestConnectModelBuilder;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.uri.BaseUri;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.ParserUtils;

public class RestConnectAPIModel {
    public static final String DEFAULT_VERSION = "1.0.0";
    private final String apiName;
    private final String description;
    private final BaseUri baseUri;
    private final ConnectorCategory category;
    private final String projectDescription;
    private final List<MavenDependency> dependencies;
    private final List<Operation> operations;
    private String groupId;
    private String artifactId;
    private String version;
    private String customPackage;
    private Path rootDir;
    private boolean tlsEnabled = false;

    public RestConnectAPIModel(RestConnectModelBuilder builder) {
        this.apiName = this.buildApiName(builder);
        this.description = this.buildApiDescription(builder);
        this.groupId = this.buildGroupId(builder);
        this.artifactId = this.buildArtifactId(builder);
        this.version = this.buildVersion(builder);
        this.customPackage = this.buildCustomPackage(builder);
        this.category = this.buildCategory(builder);
        this.dependencies = this.buildDependencies(builder);
        this.projectDescription = this.buildProjectDescription(builder);
        this.baseUri = this.buildBaseUri(builder);
        this.operations = this.buildOperations(builder);
        this.tlsEnabled = this.buildTlsEnabled(builder);
        this.rootDir = builder.getRootDir();
    }

    private List<Operation> buildOperations(RestConnectModelBuilder builder) {
        return builder.getOperations();
    }

    private boolean buildTlsEnabled(RestConnectModelBuilder builder) {
        return builder.isTlsEnabled();
    }

    private BaseUri buildBaseUri(RestConnectModelBuilder builder) {
        return builder.getBaseUri();
    }

    private String buildProjectDescription(RestConnectModelBuilder builder) {
        return builder.getProjectDescription();
    }

    private List<MavenDependency> buildDependencies(RestConnectModelBuilder builder) {
        return builder.getDependencies();
    }

    private ConnectorCategory buildCategory(RestConnectModelBuilder builder) {
        return builder.getCategory();
    }

    private String buildApiName(RestConnectModelBuilder builder) {
        return builder.getApiName();
    }

    private String buildApiDescription(RestConnectModelBuilder builder) {
        return builder.getApiDescription();
    }

    private String buildVersion(RestConnectModelBuilder builder) {
        if (!StringUtils.isBlank((String)builder.getVersion())) {
            return ParserUtils.removeMavenVersionUnwantedCharacters(builder.getVersion());
        }
        return this.getDefaultVersion();
    }

    private String buildGroupId(RestConnectModelBuilder builder) {
        if (!StringUtils.isBlank((String)builder.getGroupId())) {
            return ParserUtils.removeMavenGroupUnwantedCharacters(builder.getGroupId());
        }
        return null;
    }

    private String buildArtifactId(RestConnectModelBuilder builder) {
        if (!StringUtils.isBlank((String)builder.getArtifactId())) {
            return ParserUtils.removeMavenArtifactUnwantedCharacters(builder.getArtifactId());
        }
        return null;
    }

    private String buildCustomPackage(RestConnectModelBuilder builder) {
        if (!StringUtils.isBlank((String)builder.getCustomPackage())) {
            return builder.getCustomPackage();
        }
        return null;
    }

    public String getApiName() {
        return this.apiName;
    }

    protected String getDefaultVersion() {
        return DEFAULT_VERSION;
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCustomPackage() {
        return this.customPackage;
    }

    public ConnectorCategory getCategory() {
        return this.category;
    }

    public List<MavenDependency> getDependencies() {
        return this.dependencies;
    }

    public BaseUri getBaseUri() {
        return this.baseUri;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public String getApiDescription() {
        return this.description;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    public Path getRootDir() {
        return this.rootDir;
    }
}

