/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.model.HTTPMethod;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.model.parameter.PartParameter;
import org.mule.connectivity.restconnect.internal.modelGeneration.JsonSchemaPool;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.RamlParserTypeDefinitionFactory;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.ParserUtils;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.common.Annotable;
import org.raml.v2.api.model.v10.datamodel.FileTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.declarations.AnnotationRef;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.security.SecurityScheme;
import org.raml.v2.api.model.v10.system.types.AnnotableStringType;

public class RamlParserUtils
extends ParserUtils {
    protected RamlParserUtils() {
    }

    public static String getMethodDescription(Method method) {
        String description = null;
        if (method.description() != null) {
            description = method.description().value();
        } else if (method.resource() != null && method.resource().description() != null) {
            description = method.resource().description().value();
        }
        return StringUtils.trimToNull((String)description);
    }

    public static String getMethodDisplayName(Method method) {
        String displayName = null;
        if (method.displayName() != null && method.displayName().value() != null && !method.displayName().value().equals(method.method())) {
            displayName = method.displayName().value();
        }
        return StringUtils.trimToNull(displayName);
    }

    public static String getCanonicalOperationName(Method method, String friendlyName) {
        String annotatedOperationName = RamlParserUtils.getAnnotatedOperationName(method);
        HTTPMethod httpMethod = HTTPMethod.fromString(method.method());
        return RamlParserUtils.getCanonicalOperationName(httpMethod, method.resource().resourcePath(), friendlyName, annotatedOperationName);
    }

    public static String getAnnotatedOperationName(Method method) {
        return RamlParserUtils.getAnnotationStringValue((Annotable)method, "operationName");
    }

    public static String getAnnotatedParameterName(TypeDeclaration typeDeclaration) {
        return RamlParserUtils.getAnnotationStringValue((Annotable)typeDeclaration, "parameterName");
    }

    public static String getAnnotatedPartName(TypeDeclaration typeDeclaration) {
        return RamlParserUtils.getAnnotationStringValue((Annotable)typeDeclaration, "partName");
    }

    public static String getAnnotatedPartFilename(TypeDeclaration typeDeclaration) {
        return RamlParserUtils.getAnnotationStringValue((Annotable)typeDeclaration, "partFilename");
    }

    public static String getAnnotatedPartContentType(TypeDeclaration typeDeclaration) {
        return RamlParserUtils.getAnnotationStringValue((Annotable)typeDeclaration, "partContentType");
    }

    public static String getAnnotatedPartNameParameter(TypeDeclaration typeDeclaration) {
        return RamlParserUtils.getAnnotationStringValue((Annotable)typeDeclaration, "partNameParameter");
    }

    public static String getAnnotatedPartFilenameParameter(TypeDeclaration typeDeclaration) {
        return RamlParserUtils.getAnnotationStringValue((Annotable)typeDeclaration, "partFilenameParameter");
    }

    public static String getAnnotatedRenewTokenExpression(SecurityScheme securityScheme) {
        return RamlParserUtils.getAnnotationStringValue((Annotable)securityScheme, "renewTokenExpression");
    }

    public static String getAnnotationStringValue(Annotable target, String annotationName) {
        Optional<AnnotationRef> annotation;
        List annotations = target.annotations();
        if (annotations != null && !annotations.isEmpty() && (annotation = annotations.stream().filter(x -> x.annotation().name().equalsIgnoreCase(annotationName)).findFirst()).isPresent()) {
            return (String)annotation.get().structuredValue().value();
        }
        return null;
    }

    public static List<Parameter> getParameterList(List<TypeDeclaration> typeDeclarationParameters, ParameterType parameterType, JsonSchemaPool jsonSchemaPool) throws Exception {
        return RamlParserUtils.getParameterList(typeDeclarationParameters, false, parameterType, jsonSchemaPool);
    }

    public static List<Parameter> getParameterList(List<TypeDeclaration> typeDeclarationParameters, boolean setDefaultMediaTypes, ParameterType parameterType, JsonSchemaPool jsonSchemaPool) throws Exception {
        LinkedList<Parameter> parameters = new LinkedList<Parameter>();
        for (TypeDeclaration typeDeclaration : typeDeclarationParameters) {
            if (setDefaultMediaTypes) {
                parameters.add(new Parameter(typeDeclaration.name(), parameterType, RamlParserTypeDefinitionFactory.getTypeDefinition(typeDeclaration, RamlParserUtils.getDefaultMediaType(typeDeclaration), jsonSchemaPool)));
                continue;
            }
            parameters.add(new Parameter(typeDeclaration.name(), parameterType, RamlParserTypeDefinitionFactory.getTypeDefinition(typeDeclaration, jsonSchemaPool)));
        }
        return parameters;
    }

    public static List<PartParameter> getPartParameterList(List<TypeDeclaration> typeDeclarationParameters, JsonSchemaPool jsonSchemaPool) throws Exception {
        LinkedList<PartParameter> partParameters = new LinkedList<PartParameter>();
        for (TypeDeclaration typeDeclaration : typeDeclarationParameters) {
            String annotatedPartContentType;
            String annotatedPartFilename;
            String annotatedPartName;
            String annotatedPartFilenameParameter;
            PartParameter part = new PartParameter(typeDeclaration.name(), ParameterType.PART, RamlParserTypeDefinitionFactory.getTypeDefinition(typeDeclaration, RamlParserUtils.getDefaultMediaType(typeDeclaration), jsonSchemaPool));
            String annotatedPartNameParameter = RamlParserUtils.getAnnotatedPartNameParameter(typeDeclaration);
            if (StringUtils.isNotBlank((CharSequence)annotatedPartNameParameter)) {
                part.setPartNameParameterName(annotatedPartNameParameter);
            }
            if (StringUtils.isNotBlank((CharSequence)(annotatedPartFilenameParameter = RamlParserUtils.getAnnotatedPartFilenameParameter(typeDeclaration)))) {
                part.setPartFilenameParameterName(annotatedPartFilenameParameter);
            }
            if (StringUtils.isNotBlank((CharSequence)(annotatedPartName = RamlParserUtils.getAnnotatedPartName(typeDeclaration)))) {
                part.setPartName(annotatedPartName);
            }
            if (StringUtils.isNotBlank((CharSequence)(annotatedPartFilename = RamlParserUtils.getAnnotatedPartFilename(typeDeclaration)))) {
                part.setPartFilename(annotatedPartFilename);
            }
            if (StringUtils.isNotBlank((CharSequence)(annotatedPartContentType = RamlParserUtils.getAnnotatedPartContentType(typeDeclaration)))) {
                part.setPartContentType(annotatedPartContentType);
            }
            partParameters.add(part);
        }
        return partParameters;
    }

    private static String getDefaultMediaType(TypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof FileTypeDeclaration) {
            return "application/octet-stream";
        }
        if (RamlParserTypeDefinitionFactory.typeIsDefinedWithRAML(typeDeclaration)) {
            return "application/json";
        }
        if (RamlParserTypeDefinitionFactory.typeIsDefinedWithJSONSchema(typeDeclaration)) {
            return "application/json";
        }
        if (RamlParserTypeDefinitionFactory.typeIsDefinedWithXMLSchema(typeDeclaration)) {
            return "application/xml";
        }
        return "text/plain";
    }

    public static String getValueFromAnnotableString(AnnotableStringType annotableString) {
        return annotableString == null ? null : annotableString.value();
    }

    public static boolean isIgnored(Method method) {
        for (AnnotationRef annotationRef : method.annotations()) {
            if (!"ignored".equals(annotationRef.annotation().name())) continue;
            return true;
        }
        return false;
    }

    public static boolean isDefault(TypeDeclaration typeDeclaration) {
        for (AnnotationRef annotationRef : typeDeclaration.annotations()) {
            if (!"default".equals(annotationRef.annotation().name())) continue;
            return true;
        }
        return false;
    }

    public static boolean isGenerateUserSelectedSecuritySchemes(Method method, Api api) {
        for (AnnotationRef annotationRef : method.annotations()) {
            if (!"userSelectedSecuritySchemes".equals(annotationRef.annotation().name())) continue;
            return true;
        }
        for (AnnotationRef annotationRef : api.annotations()) {
            if (!"userSelectedSecuritySchemes".equals(annotationRef.annotation().name())) continue;
            return true;
        }
        return false;
    }
}

