package org.mule.connectivity.restconnect.internal.model.security;

import org.raml.v2.api.model.v10.datamodel.TypeInstance;
import org.raml.v2.api.model.v10.datamodel.TypeInstanceProperty;

import java.util.ArrayList;
import java.util.List;

import static java.util.stream.Collectors.toList;

public class JwtFieldDefinition {
    private final String name;
    private final List<String> restrictedValues;
    private final boolean required;
    private final String description;
    private final JwtRandomizableStrategy randomizableStrategy;

    public JwtFieldDefinition(List<TypeInstanceProperty> properties) {
        this.name = properties.stream().filter(property -> property.name().equals("name"))
                .findFirst()
                .map(TypeInstanceProperty::value)
                .map(TypeInstance::value)
                .map(Object::toString)
                .orElse(null);
        this.description = properties.stream().filter(property -> property.name().equals("description"))
                .findFirst()
                .map(TypeInstanceProperty::value)
                .map(TypeInstance::value)
                .map(Object::toString)
                .orElse(null);
        this.required = properties.stream().filter(property -> property.name().equals("required"))
                .findFirst()
                .map(TypeInstanceProperty::value)
                .map(TypeInstance::value)
                .map(Boolean.class::cast)
                .orElse(true);

        this.restrictedValues = properties.stream().filter(property -> property.name().equals("restrictedValues"))
                .findFirst()
                .map(TypeInstanceProperty::values)
                .orElseGet(ArrayList::new)
                .stream()
                .map(TypeInstance::value)
                .map(Object::toString)
                .collect(toList());

        this.randomizableStrategy = properties.stream().filter(property -> property.name().equals("randomizable"))
                .findFirst()
                .map(TypeInstanceProperty::value)
                .map(TypeInstance::properties)
                .map(JwtRandomizableStrategy::new)
                .orElse(null);
    }

    public String getName() {
        return name;
    }

    public JwtRandomizableStrategy getRandomizableStrategy() {
        return randomizableStrategy;
    }

    public List<String> getRestrictedValues() {
        return restrictedValues;
    }

    public String getDescription() {
        return description;
    }

    public boolean isRequired() {
        return required;
    }
}
