package org.mule.connectivity.restconnect.internal.model.security;

import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;

import java.util.LinkedList;
import java.util.List;

public class PassThroughScheme extends APISecurityScheme {

    public PassThroughScheme(List<Parameter> queryParameters, List<Parameter> headers) {
        this.queryParameters = queryParameters;
        this.headers = headers;
        initializeConfigParameters();
    }

    @Override
    public String getSchemeName() {
        return PASS_THROUGH;
    }

    @Override
    protected boolean equalProperties(APISecurityScheme scheme) {
        PassThroughScheme other = (PassThroughScheme)scheme;

        return compareParameterList(this.queryParameters, other.queryParameters)
               && compareParameterList(this.headers, other.headers);
    }

    @Override
    public void initializeConfigParameters() {
        configParameters = new LinkedList<>();
        configParameters.addAll(getQueryParameters());
        configParameters.addAll(getHeaders());
    }

    private boolean compareParameterList(List<Parameter> thisList, List<Parameter> otherList) {
        if(thisList == null){
            return otherList == null;
        }
        else{
            if(thisList.size() != otherList.size()){
                return false;
            }

            for(Parameter param : thisList){
                boolean exists = false;
                for(Parameter otherParam : otherList){
                    if(param.getExternalName().equals(otherParam.getExternalName())){
                        exists = true;
                        break;
                    }
                }
                if(!exists){
                    return false;
                }
            }
        }

        return true;
    }
}
