package org.mule.connectivity.restconnect.internal.model.uri;

import org.apache.commons.lang.StringUtils;

import java.net.URISyntaxException;

import static org.apache.commons.lang.StringUtils.isBlank;
import static org.apache.commons.lang.StringUtils.isNotBlank;

public class BaseUriBuilder {

    public final static String VERSION_URI_PARAM = "{version}";
    public final static String VERSION_URI_PARAM_REGEX = "\\{version\\}";

    private static String buildBaseUriString(String baseUri, String version) {
        // Base cases.
        if(baseUri == null) {
            return "";
        }

        // We replace parameters with the version if it is a template.
        if(baseUri.contains(VERSION_URI_PARAM) && isNotBlank(version)){
            return baseUri.replaceAll(VERSION_URI_PARAM_REGEX, version);
        }

        // If it doesn't have the version then we return empty.
        else if(baseUri.contains(VERSION_URI_PARAM)){
            return "";
        }

        return baseUri;
    }


    public static BaseUri buildBaseUri(String baseUri, String version){
        String baseUriString = buildBaseUriString(baseUri, version);

        if(isBlank(baseUriString)){
            return null;
        }

        if(baseUriString.endsWith("/")){
            baseUriString = StringUtils.chop(baseUriString);
        }

        try {
            BaseUri uri = new BaseUri(baseUriString);
            if(!uri.isAbsolute())
                return null;
            return uri;
        } catch (URISyntaxException e) {
            return null;
        }
    }
}
