package org.mule.connectivity.restconnect.internal.modelGeneration.amf.resourceLoader;

import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import amf.core.client.common.remote.Content;
import amf.core.client.platform.resource.FileResourceLoader;
import amf.core.client.platform.resource.ResourceLoader;

public class AMFExchangeDependencyResourceLoader implements ResourceLoader {
    private File workingDir;
    private final FileResourceLoader resourceLoader = new FileResourceLoader();

    private static final Pattern DEPENDENCY_PATH_PATTERN = Pattern.compile("^exchange_modules/|/exchange_modules/");

    public AMFExchangeDependencyResourceLoader(String rootDir) {
        String basePath = rootDir != null ? rootDir : ".";
        workingDir = new File(basePath);
    }

    @Override
    public CompletableFuture<Content> fetch(String path) {
        if (path == null || path.isEmpty()){
            return fail();
        }

        path = path.startsWith("file://") ? path.substring(6) : path;

        final Matcher matcher = DEPENDENCY_PATH_PATTERN.matcher(path);
        if (matcher.find()) {

            final int dependencyIndex = path.lastIndexOf(matcher.group(0));
            final String resourceName = dependencyIndex <= 0 ? path : path.substring(dependencyIndex);
            return resourceLoader.fetch(new File(workingDir, resourceName).getAbsolutePath());
        }
        return fail();
    }

    @Override
    public boolean accepts(final String resource){
        if(resourceLoader.accepts(resource)){
            String path = resource.startsWith("file://") ? resource.substring(7) : resource;
            final Matcher matcher = DEPENDENCY_PATH_PATTERN.matcher(path);
            return matcher.find();
        }
        return false;
    }

    private CompletableFuture<Content> fail() {
        return CompletableFuture.supplyAsync(() -> {
            throw new RuntimeException("Failed to apply.");
        });
    }
}
