package org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.util;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.TreeTraverser;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.OperationMappingUtils;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;

import javax.annotation.Nullable;
import java.util.List;

public class RamlOperationMappingUtils extends OperationMappingUtils{

    /* Avoid instantiation*/
    protected RamlOperationMappingUtils(){

    }

    private static final TreeTraverser<Resource> TRAVERSER = new TreeTraverser<Resource>() {

        @Override
        public Iterable<Resource> children(Resource root) {
            return root.resources();
        }

    };

    /**
     * Traverses the RAML and extracts all actions that will eventually become operations
     * @param api
     */
    public static List<Method> getMethods(Api api) {
        List<Resource> resources = api.resources();

        return FluentIterable.from(resources).transformAndConcat(new Function<Resource, Iterable<Resource>>() {

            @Nullable
            @Override
            public Iterable<Resource> apply(@Nullable Resource input) {
                return TRAVERSER.preOrderTraversal(input);
            }

        }).transformAndConcat(new Function<Resource, Iterable<Method>>() {

            @Nullable
            @Override
            public Iterable<Method> apply(@Nullable Resource input) {
                return input.methods();
            }

        }).toList();
    }
}
