package org.mule.connectivity.restconnect.internal.templateEngine;

import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.tools.ToolManager;
import org.mule.connectivity.restconnect.exception.GenerationException;
import org.mule.connectivity.restconnect.internal.util.DataWeaveUtils;
import org.mule.connectivity.restconnect.internal.util.JavaRequestUtils;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;


public abstract class TemplateEngine {

    protected static ToolManager velocityToolManager;

    static {
        velocityToolManager = new ToolManager();
        velocityToolManager.configure("velocity-tools.xml");
    }

    public abstract void applyTemplates() throws Exception;

    protected Path applyTemplate(String templateVm, Path output, VelocityContext context) throws IOException {
        Files.createDirectories(output.getParent());
        context.put("StringUtils", StringUtils.class);
        context.put("DataWeaveUtils", DataWeaveUtils.class);
        context.put("JavaRequestUtils", JavaRequestUtils.class);

        VelocityEngine ve = new VelocityEngine();
        ve.setProperty(RuntimeConstants.RESOURCE_LOADERS, "classpath");
        ve.setProperty("resource.loader.classpath.class", ClasspathResourceLoader.class.getName());
        ve.init();

        Template template = ve.getTemplate(templateVm, "UTF-8");
        try (BufferedWriter writer = Files.newBufferedWriter(output)) {
            template.merge(context, writer);
        }

        return output;
    }

    protected void checkPomIsConsistent(Path pomPath) throws GenerationException {
        try (InputStream is = Files.newInputStream(pomPath)) {
            new MavenXpp3Reader().read(is);
        } catch (Exception e) {
            throw new GenerationException("Error while checking pom consistency of file '" + pomPath + '\'', e);
        }
    }
}
