/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.amf.resourceLoader;

import amf.core.client.common.remote.Content;
import amf.core.client.platform.resource.BaseHttpResourceLoader;
import amf.core.internal.remote.UnexpectedStatusCode;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import org.codehaus.plexus.util.IOUtil;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.ResourceLoaderUtils;
import scala.Option;

public class SafeProxyResourceLoader
extends BaseHttpResourceLoader {
    private static final String USER_AGENT = "rest-connect";
    private final String proxyBaseUri;
    private final String referer;
    private final String token;
    private final String orgId;

    public SafeProxyResourceLoader(String proxyBaseUri, String referer, String token, String orgId) {
        this.proxyBaseUri = proxyBaseUri.endsWith("/") ? proxyBaseUri.substring(0, proxyBaseUri.length() - 1) : proxyBaseUri;
        this.referer = referer;
        this.token = token;
        this.orgId = orgId;
    }

    public CompletableFuture<Content> fetch(String resource) {
        if (resource == null || resource.isEmpty()) {
            return this.fail();
        }
        CompletableFuture<Content> f = new CompletableFuture<Content>();
        CompletableFuture.runAsync(() -> {
            try {
                URL u = new URL(String.format("%s/%s", this.proxyBaseUri, resource));
                HttpURLConnection connection = ResourceLoaderUtils.getHttpURLConnection(u, this.referer, this.token, this.orgId);
                Content content = this.createContent(connection);
                f.complete(content);
            }
            catch (Exception e) {
                f.completeExceptionally(e);
            }
            f.completeExceptionally(new Exception("Could not complete future"));
        });
        return f;
    }

    private Content createContent(HttpURLConnection connection) throws Exception {
        connection.connect();
        int statusCode = connection.getResponseCode();
        if (statusCode == 200) {
            Option option = Option.apply((Object)connection.getHeaderField("Content-Type"));
            return new Content(IOUtil.toString((InputStream)connection.getInputStream()), connection.getURL().toString(), option);
        }
        throw new UnexpectedStatusCode(connection.getURL().toString(), statusCode);
    }

    private CompletableFuture<Content> fail() {
        return CompletableFuture.supplyAsync(() -> {
            throw new RuntimeException("Failed to apply.");
        });
    }
}

