/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.resourceLoader;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nullable;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.ResourceLoaderUtils;
import org.raml.v2.api.loader.ResourceLoaderExtended;
import org.raml.v2.api.loader.ResourceUriCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeProxyResourceLoader
implements ResourceLoaderExtended {
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeProxyResourceLoader.class);
    private final String proxyUri;
    private final String proxyReferer;
    private final String token;
    private final String orgId;
    private URI callbackParam;

    public SafeProxyResourceLoader(String proxyUri, String proxyReferer, String token, String orgId) {
        this.proxyUri = proxyUri;
        this.proxyReferer = proxyReferer;
        this.token = token;
        this.orgId = orgId;
    }

    public InputStream fetchResource(String resourceName, ResourceUriCallback callback) {
        BufferedInputStream inputStream = null;
        try {
            URL url = new URL(String.format("%s/%s", this.proxyUri, resourceName));
            HttpURLConnection connection = ResourceLoaderUtils.getHttpURLConnection(url, this.proxyReferer, this.token, this.orgId);
            if (connection.getResponseCode() != 200) {
                return null;
            }
            inputStream = new BufferedInputStream(connection.getInputStream());
            if (callback != null) {
                this.callbackParam = url.toURI();
                callback.onResourceFound(url.toURI());
            }
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.warn("Error fetching resource", (Throwable)e);
        }
        return inputStream;
    }

    @Nullable
    public InputStream fetchResource(String resourceName) {
        return this.fetchResource(resourceName, null);
    }

    public URI getUriCallBackParam() {
        return this.callbackParam;
    }
}

