package org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector;

import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class SmartConnectorDigestSchemeDecorator extends SmartConnectorSecuritySchemeDecorator {

    public SmartConnectorDigestSchemeDecorator(APISecurityScheme securityScheme, HashMap<APISecurityScheme, String> securitySchemesNames, boolean tlsEnabled) {
        super(securityScheme, securitySchemesNames, tlsEnabled);
    }

    @Override
    protected List<SmartConnectorXMLSchemaLocation> buildXmlSchemaLocations() {
        return new LinkedList<>();
    }

    @Override
    protected List<SmartConnectorXMLSchema> buildXmlSchemas() {
        return new LinkedList<>();
    }

    @Override
    protected List<SmartConnectorXMLConfig> buildXmlConfigs() {
        return new LinkedList<>();
    }

    @Override
    protected List<SmartConnectorPomDependency> buildPomDependencies() {
        return new LinkedList<>();
    }

    @Override
    public String getHttpAuthorizationConfigString() {
        StringBuilder builder = new StringBuilder();

        builder.append("<http:authentication>").append(System.lineSeparator());

        builder.append("<http:digest-authentication").append(System.lineSeparator());

        builder.append(getConfigLineForProperty("username", "username"));
        builder.append(getConfigLineForProperty("password", "password"));

        builder.append("/>").append(System.lineSeparator());
        builder.append("</http:authentication>").append(System.lineSeparator());

        return builder.toString();
    }
}
