package org.mule.connectivity.restconnect.internal.modelGeneration;

import org.mule.connectivity.restconnect.api.Parser;
import org.mule.connectivity.restconnect.api.SpecFormat;
import org.mule.connectivity.restconnect.internal.model.api.RestConnectModelBuilder;
import org.mule.connectivity.restconnect.internal.modelGeneration.amf.AMFModelGenerator;
import org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.RamlParserModelGenerator;

import java.io.File;

public abstract class ModelGenerator {
    protected final SpecFormat specFormat;
    protected String proxyUri;
    protected String proxyReferer;
    protected String token;
    protected String orgId;
    protected boolean safeFileLoader;

    protected boolean tlsEnabled = false;

    public ModelGenerator(SpecFormat specFormat){
        this.specFormat = specFormat;
    }

    public abstract RestConnectModelBuilder generateAPIModel(File raml, String rootDir) throws Exception;

    public RestConnectModelBuilder generateAPIModel(File raml) throws Exception {
        return generateAPIModel(raml, raml.getParent());
    }

    public void withSafeProxy(String proxyUri, String proxyReferer, String token, String orgId){
        this.proxyUri = proxyUri;
        this.proxyReferer = proxyReferer;
        this.token = token;
        this.orgId = orgId;
    }

    public void withSafeFileLoader(boolean useSafeFileLoader){
        this.safeFileLoader = useSafeFileLoader;
    }

    public void withTlsEnabled(boolean tlsEnabled) { this.tlsEnabled = tlsEnabled; }
    public static ModelGenerator get(SpecFormat format, Parser parser){

        if (parser.equals(Parser.RAMLParser)) {
            return new RamlParserModelGenerator(format);
        }

        else if (parser.equals(Parser.AMF)) {
            return new AMFModelGenerator(format);
        }

        throw new IllegalArgumentException("Parser not supported");
    }

}
