/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.model.security;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.mule.connectivity.model.operation.Operation;
import org.mule.connectivity.model.parameter.TypeDefinition;
import org.mule.connectivity.model.security.APISecurityScheme;
import org.mule.connectivity.templateEngine.decorator.operation.SmartConnectorOperationDecorator;
import org.mule.connectivity.templateEngine.decorator.type.ConnectorTypeDefinitionDecorator;
import org.mule.connectivity.templateEngine.decorator.type.SmartConnectorTypeDefinitionDecorator;
import org.raml.v2.api.model.v10.security.SecurityScheme;
import org.raml.v2.api.model.v10.security.SecuritySchemePart;

public class PassThroughScheme
implements APISecurityScheme {
    private static final String PASS_THROUGH_CONFIG_TEMPLATE_VM = "templates/devkit/PassThroughConfig.vm";
    private Map<String, TypeDefinition> queryParameters;
    private Map<String, TypeDefinition> headers;

    public PassThroughScheme(SecurityScheme securityScheme) {
        this.buildParameters(securityScheme);
    }

    @Override
    public String getSchemeName() {
        return "Pass Through";
    }

    @Override
    public String getConfigurationName() {
        return "PassThroughConfig.java";
    }

    @Override
    public String getTemplateLocation() {
        return PASS_THROUGH_CONFIG_TEMPLATE_VM;
    }

    public boolean hasQueryParameters() {
        return !this.queryParameters.isEmpty();
    }

    public boolean hasHeaders() {
        return !this.headers.isEmpty();
    }

    public Map<String, TypeDefinition> getQueryParameters() {
        return this.queryParameters;
    }

    public Map<String, TypeDefinition> getHeaders() {
        return this.headers;
    }

    public List<ConnectorTypeDefinitionDecorator> getDecoratedConnectorQueryParameters() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String parameterName : this.queryParameters.keySet()) {
            builder.add((Object)new ConnectorTypeDefinitionDecorator(parameterName, this.queryParameters.get(parameterName), "dummy-package"));
        }
        return builder.build();
    }

    public List<ConnectorTypeDefinitionDecorator> getDecoratedConnectorHeaders() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String parameterName : this.headers.keySet()) {
            builder.add((Object)new ConnectorTypeDefinitionDecorator(parameterName, this.headers.get(parameterName), "dummy-package"));
        }
        return builder.build();
    }

    public List<SmartConnectorTypeDefinitionDecorator> getDecoratedQueryParameters() {
        return SmartConnectorOperationDecorator.buildDecoratedParameters(this.queryParameters, null);
    }

    public List<SmartConnectorTypeDefinitionDecorator> getDecoratedHeaders() {
        return SmartConnectorOperationDecorator.buildDecoratedParameters(this.headers, null);
    }

    private void buildParameters(SecurityScheme securityScheme) {
        SecuritySchemePart describedBy = securityScheme.describedBy();
        this.queryParameters = Operation.getParameterList(describedBy.queryParameters());
        this.headers = Operation.getParameterList(describedBy.headers());
    }
}

