/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.templateEngine;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.mule.extension.http.internal.temporary.HttpConnector;
import org.mule.extension.oauth2.OAuthExtension;
import org.mule.extension.socket.api.SocketsExtension;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.loader.xml.XmlExtensionModelLoader;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;
import org.mule.runtime.module.extension.api.loader.java.DefaultJavaExtensionModelLoader;

public class ExtensionModelGenerator {
    private static final String EXTENSIONS_VERSION = "1.0.0";

    public Path generateExtensionModel(Path xmlModuleFile, boolean includeOAuthDependency, Path outputDir) throws IOException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("resource-xml", xmlModuleFile.getFileName().toString());
        parameters.put("validate-xml", true);
        URLClassLoader simple = new URLClassLoader(new URL[]{xmlModuleFile.getParent().toUri().toURL()}, this.getClass().getClassLoader());
        ExtensionModel extensionModel = new XmlExtensionModelLoader().loadExtensionModel(simple, DslResolvingContext.getDefault(this.getDependencyExtensions(includeOAuthDependency, null)), parameters);
        String serializedExtensionModel = new ExtensionModelJsonSerializer(true).serialize(extensionModel);
        Path outputFile = outputDir.resolve("extension-model.json");
        outputFile.toFile().getParentFile().mkdirs();
        Files.write(outputFile, serializedExtensionModel.getBytes("UTF-8"), new OpenOption[0]);
        return outputFile;
    }

    private Set<ExtensionModel> getDependencyExtensions(boolean oauth, ClassLoader classLoader) {
        ExtensionModel sockets = this.loadExtension(SocketsExtension.class, Collections.emptySet(), classLoader);
        ExtensionModel http = this.loadExtension(HttpConnector.class, Collections.singleton(sockets), classLoader);
        ImmutableSet.Builder builder = ImmutableSet.builder().add((Object)http).add((Object)sockets);
        if (oauth) {
            ExtensionModel oauthExtensionModel = this.loadExtension(OAuthExtension.class, Collections.emptySet(), classLoader);
            builder.add((Object)oauthExtensionModel);
        }
        return builder.build();
    }

    private ExtensionModel loadExtension(Class extension, Set<ExtensionModel> deps, ClassLoader classLoader) {
        DefaultJavaExtensionModelLoader loader = new DefaultJavaExtensionModelLoader();
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("type", extension.getName());
        ctx.put("version", EXTENSIONS_VERSION);
        return loader.loadExtensionModel(Thread.currentThread().getContextClassLoader(), DslResolvingContext.getDefault(deps), ctx);
    }
}

