/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.templateEngine.decorator.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.model.api.RestConnectAPIModel;
import org.mule.connectivity.model.operation.Operation;
import org.mule.connectivity.templateEngine.decorator.model.ModelDecorator;
import org.mule.connectivity.templateEngine.decorator.operation.ConnectorOperationDecorator;
import org.mule.connectivity.util.ParserUtils;

public class ConnectorModelDecorator
extends ModelDecorator {
    public static final String DEFAULT_ARTIFACT_ID_PREFIX = "mule-module-";
    public static final String DEFAULT_GROUP_ID = "org.mule.modules";
    private final List<ConnectorOperationDecorator> decoratedOperations;
    private final String basePackage = this.createBasePackage();

    public ConnectorModelDecorator(RestConnectAPIModel model) {
        super(model);
        this.decoratedOperations = this.buildDecoratedOperations();
    }

    private List<ConnectorOperationDecorator> buildDecoratedOperations() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Operation operation : this.getOperations()) {
            builder.add((Object)new ConnectorOperationDecorator(operation, this.basePackage));
        }
        return builder.build();
    }

    private String createBasePackage() {
        if (super.getCustomPackage() != null) {
            return ParserUtils.removeSpacesAndHyphens(this.getCustomPackage() + "." + this.getApiName()).toLowerCase();
        }
        return ParserUtils.removeSpacesAndHyphens(this.getGroupId() + "." + this.getApiName()).toLowerCase();
    }

    @Override
    public String getGroupId() {
        return StringUtils.isNotBlank((CharSequence)super.getGroupId()) ? super.getGroupId() : DEFAULT_GROUP_ID;
    }

    @Override
    public String getArtifactId() {
        return StringUtils.isNotBlank((CharSequence)super.getArtifactId()) ? super.getArtifactId() : this.getDefaultArtifactId();
    }

    private String getDefaultArtifactId() {
        return DEFAULT_ARTIFACT_ID_PREFIX + ParserUtils.removeSpaces(this.getApiName()).toLowerCase();
    }

    public String getConnectorName() {
        return ParserUtils.getXmlName(this.getApiName(), null, null);
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public String getClassName() {
        return ParserUtils.removeSpacesAndHyphens(this.getApiName()) + "Connector";
    }

    public List<ConnectorOperationDecorator> getDecoratedOperations() {
        return this.decoratedOperations;
    }

    public String getBaseUriAsString() {
        return this.getBaseUri().toString();
    }

    @Override
    public String getApiDescription() {
        if (StringUtils.isNotBlank((CharSequence)this.model.getApiDescription())) {
            String lineSeparator = System.getProperty("line.separator");
            StringBuilder builder = new StringBuilder();
            builder.append("/**").append(lineSeparator).append("*").append(this.model.getApiDescription().replace(lineSeparator, lineSeparator + "*")).append(lineSeparator).append("*/").append(lineSeparator);
            return builder.toString();
        }
        return "";
    }
}

