/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.templateEngine.decorator.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.model.api.RestConnectAPIModel;
import org.mule.connectivity.model.operation.Operation;
import org.mule.connectivity.model.security.APISecurityScheme;
import org.mule.connectivity.templateEngine.decorator.model.ModelDecorator;
import org.mule.connectivity.templateEngine.decorator.operation.SmartConnectorOperationDecorator;
import org.mule.connectivity.util.ParserUtils;

public class SmartConnectorModelDecorator
extends ModelDecorator {
    public static final String DEFAULT_GROUP_ID = "org.mule.modules.extensions";
    public static final String DEFAULT_ARTIFACT_PREFIX = "mule-module-";
    private final List<SmartConnectorOperationDecorator> decoratedOperations = this.buildDecoratedOperations();

    public SmartConnectorModelDecorator(RestConnectAPIModel model) {
        super(model);
    }

    private List<SmartConnectorOperationDecorator> buildDecoratedOperations() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Operation operation : this.getOperations()) {
            builder.add((Object)new SmartConnectorOperationDecorator(operation, this.getGav()));
        }
        return builder.build();
    }

    @Override
    public String getGroupId() {
        return StringUtils.isNotBlank((CharSequence)super.getGroupId()) ? super.getGroupId() : DEFAULT_GROUP_ID;
    }

    @Override
    public String getArtifactId() {
        return StringUtils.isNotBlank((CharSequence)super.getArtifactId()) ? super.getArtifactId() : this.getDefaultArtifactId();
    }

    private String getDefaultArtifactId() {
        return DEFAULT_ARTIFACT_PREFIX + this.getModulePrefix(false);
    }

    public String getModulePrefix() {
        return ParserUtils.getXmlName(this.getApiName(), this.getGav(), "module prefix");
    }

    public String getModulePrefix(boolean asd) {
        return ParserUtils.getXmlName(this.getApiName(), null, null);
    }

    public String getGav() {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion();
    }

    public String getNamespace() {
        return "http://www.mulesoft.org/schema/mule/" + this.getModulePrefix();
    }

    public String getBasePath() {
        if (this.getBaseUri() == null) {
            return null;
        }
        return this.getBaseUri().getPath();
    }

    public String getProtocol() {
        if (this.getBaseUri() == null) {
            return null;
        }
        return this.getBaseUri().getScheme().toUpperCase();
    }

    public String getHost() {
        if (this.getBaseUri() == null) {
            return null;
        }
        return this.getBaseUri().getHost();
    }

    public Integer getPort() {
        if (this.getBaseUri() == null) {
            return null;
        }
        if (this.getBaseUri().getPort() != -1) {
            return this.getBaseUri().getPort();
        }
        switch (this.getProtocol()) {
            case "HTTP": {
                return 80;
            }
            case "HTTPS": {
                return 443;
            }
        }
        return null;
    }

    public List<SmartConnectorOperationDecorator> getDecoratedOperations() {
        return this.decoratedOperations;
    }

    public String getProjectDescription() {
        String projectDescription = this.model.getProjectDescription();
        String apiDescription = this.model.getApiDescription();
        if (StringUtils.isNotBlank((CharSequence)projectDescription) && StringUtils.isNotBlank((CharSequence)apiDescription)) {
            return String.format("%s - %s", projectDescription, apiDescription);
        }
        if (StringUtils.isNotBlank((CharSequence)projectDescription)) {
            return projectDescription;
        }
        if (StringUtils.isNotBlank((CharSequence)apiDescription)) {
            return apiDescription;
        }
        return null;
    }

    @Override
    public List<APISecurityScheme> getSecuritySchemes() {
        throw new NotImplementedException("You should not come here");
    }
}

