/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.json.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import java.util.function.Consumer;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.json.api.handler.HandlerManager;
import org.mule.metadata.json.api.handler.ParsingContext;

public class JsonTypeLoader
implements TypeLoader {
    public static MetadataFormat JSON = MetadataFormat.JSON;
    private JsonSchemaLoader jsonSchemaLoader;

    public JsonTypeLoader(File schemaFile) {
        this.jsonSchemaLoader = new JsonSchemaFileLoader(schemaFile);
    }

    public JsonTypeLoader(String schemaData) {
        this(schemaData, null);
    }

    public JsonTypeLoader(String schemaData, URI baseURI) {
        this.jsonSchemaLoader = new JsonSchemaStringLoader(schemaData, baseURI);
    }

    public static Schema generateSchema(JSONObject rawSchema, URI baseUri, Consumer<SchemaLoader.SchemaLoaderBuilder> schemaLoaderBuilderConsumer) {
        SchemaLoader.SchemaLoaderBuilder schemaLoaderBuilder = new SchemaLoader.SchemaLoaderBuilder();
        Optional.ofNullable(baseUri).ifPresent(uri -> {
            schemaLoaderBuilder.resolutionScope(baseUri);
            if (schemaLoaderBuilderConsumer != null) {
                schemaLoaderBuilderConsumer.accept(schemaLoaderBuilder);
            }
        });
        schemaLoaderBuilder.schemaJson(rawSchema);
        SchemaLoader schemaLoader = schemaLoaderBuilder.build();
        return schemaLoader.load().build();
    }

    private static Schema generateSchema(JSONObject rawSchema, URI baseUri) {
        return JsonTypeLoader.generateSchema(rawSchema, baseUri, null);
    }

    private JsonSchemaLoader getJsonSchemaLoader() {
        return this.jsonSchemaLoader;
    }

    @Override
    public Optional<MetadataType> load(String identifier) {
        return this.load(identifier, null);
    }

    @Override
    public Optional<MetadataType> load(String identifier, String typeAlias) {
        Schema jsonSchema = this.getJsonSchemaLoader().loadSchema();
        TypeBuilder<?> typeBuilder = new HandlerManager().handle(jsonSchema, new ParsingContext());
        MetadataTypeUtils.addTypeAlias(typeBuilder, typeAlias);
        return Optional.of(typeBuilder.build());
    }

    private static class JsonSchemaStringLoader
    implements JsonSchemaLoader {
        private final URI baseURI;
        private String schemaData;

        public JsonSchemaStringLoader(String schemaData, URI baseURI) {
            this.schemaData = schemaData;
            this.baseURI = baseURI;
        }

        @Override
        public Schema loadSchema() {
            JSONObject rawSchema = new JSONObject(new JSONTokener(this.schemaData));
            return JsonTypeLoader.generateSchema(rawSchema, this.baseURI);
        }
    }

    private static class JsonSchemaFileLoader
    implements JsonSchemaLoader {
        private File schemaFile;

        public JsonSchemaFileLoader(File schemaFile) {
            this.schemaFile = schemaFile;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Schema loadSchema() {
            try (FileInputStream inputStream = new FileInputStream(this.schemaFile);){
                JSONObject rawSchema = new JSONObject(new JSONTokener(inputStream));
                Schema schema = JsonTypeLoader.generateSchema(rawSchema, this.schemaFile.toURI());
                return schema;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static interface JsonSchemaLoader {
        public Schema loadSchema();
    }
}

