/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.json.api.handler;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.internal.utils.StringUtils;
import org.mule.metadata.json.api.handler.HandlerManager;
import org.mule.metadata.json.api.handler.ParsingContext;
import org.mule.metadata.json.api.handler.SchemaHandler;

public class ObjectHandler
implements SchemaHandler {
    @Override
    public boolean handles(Schema schema) {
        return schema instanceof ObjectSchema;
    }

    @Override
    public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, HandlerManager handlerManager, ParsingContext parsingContext) {
        String id;
        String title;
        ObjectSchema objectSchema = (ObjectSchema)schema;
        ObjectTypeBuilder objectMetadataBuilder = root.objectType();
        parsingContext.registerBuilder(objectSchema, objectMetadataBuilder);
        String description = objectSchema.getDescription();
        if (StringUtils.isNotEmpty(description)) {
            objectMetadataBuilder.description(description);
        }
        if (StringUtils.isNotEmpty(title = objectSchema.getTitle())) {
            objectMetadataBuilder.label(title);
        }
        if (StringUtils.isNotEmpty(id = objectSchema.getId())) {
            objectMetadataBuilder.id(id);
        }
        Set<Map.Entry<String, Schema>> properties = objectSchema.getPropertySchemas().entrySet();
        List<String> requiredProperties = objectSchema.getRequiredProperties();
        for (Map.Entry<String, Schema> property : properties) {
            ObjectFieldTypeBuilder field = objectMetadataBuilder.addField().key(property.getKey());
            field.required(requiredProperties.contains(property.getKey()));
            Schema value = property.getValue();
            field.value(handlerManager.handle(value, parsingContext));
        }
        Map<Pattern, Schema> patternProperties = objectSchema.getPatternProperties();
        Collection entries = patternProperties.entrySet().stream().sorted((o1, o2) -> ((Pattern)o1.getKey()).toString().compareTo(((Pattern)o2.getKey()).toString())).collect(Collectors.toList());
        for (Map.Entry patternSchemaEntry : entries) {
            ObjectFieldTypeBuilder field = objectMetadataBuilder.addField();
            field.key((Pattern)patternSchemaEntry.getKey());
            Schema value = (Schema)patternSchemaEntry.getValue();
            field.value(handlerManager.handle(value, parsingContext));
        }
        if (objectSchema.permitsAdditionalProperties()) {
            objectMetadataBuilder.openWith(handlerManager.handle(objectSchema.getSchemaOfAdditionalProperties(), parsingContext));
        }
        return objectMetadataBuilder;
    }
}

