/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MetadataInvocationHandler;
import org.mule.runtime.core.api.registry.IllegalDependencyInjectionException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.config.preferred.PreferredObjectSelector;

public class InjectParamsFromContextServiceProxy
extends MetadataInvocationHandler<Service> {
    public static final String MANY_CANDIDATES_ERROR_MSG_TEMPLATE = "More than one invocation candidate for for method '%s' in service '%s'";
    public static final String NO_OBJECT_FOUND_FOR_PARAM = "No object found in the registry for parameter '%s' of method '%s' in service '%s'";
    private final Registry registry;

    public InjectParamsFromContextServiceProxy(Service service, Registry registry) {
        super(service);
        Preconditions.checkArgument(registry != null, "context cannot be null");
        this.registry = registry;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method injectable = this.resolveInjectableMethod(method);
        if (injectable == null) {
            return this.doInvoke(proxy, method, args);
        }
        ArrayList augmentedArgs = args == null ? new ArrayList() : new ArrayList<Object>(Arrays.asList(args));
        for (int i = method.getParameters().length; i < injectable.getParameters().length; ++i) {
            Object arg;
            Parameter parameter = injectable.getParameters()[i];
            if (parameter.isAnnotationPresent(Named.class)) {
                arg = this.registry.lookupByName(parameter.getAnnotation(Named.class).value()).orElseThrow(() -> new IllegalDependencyInjectionException(String.format(NO_OBJECT_FOUND_FOR_PARAM, parameter.getName(), injectable.getName(), ((Service)this.getProxiedObject()).getName())));
            } else {
                Collection<?> lookupObjects = this.registry.lookupAllByType(parameter.getType());
                arg = new PreferredObjectSelector().select(lookupObjects.iterator());
            }
            augmentedArgs.add(arg);
        }
        return this.doInvoke(proxy, injectable, augmentedArgs.toArray());
    }

    private Method resolveInjectableMethod(Method method) {
        Method candidate = null;
        for (Method serviceImplMethod : this.getImplementationDeclaredMethods()) {
            if (!Modifier.isPublic(serviceImplMethod.getModifiers()) || !serviceImplMethod.getName().equals(method.getName()) || ((Inject[])serviceImplMethod.getAnnotationsByType(Inject.class)).length <= 0 || !this.equivalentParams(method.getParameters(), serviceImplMethod.getParameters())) continue;
            if (!(candidate == null || candidate.getName().equals(serviceImplMethod.getName()) && Arrays.deepEquals(candidate.getParameterTypes(), serviceImplMethod.getParameterTypes()))) {
                throw new IllegalDependencyInjectionException(String.format(MANY_CANDIDATES_ERROR_MSG_TEMPLATE, method.getName(), ((Service)this.getProxiedObject()).getName()));
            }
            candidate = serviceImplMethod;
        }
        return candidate;
    }

    private boolean equivalentParams(Parameter[] invocationParams, Parameter[] serviceImplParams) {
        int i = 0;
        for (Parameter invocationParam : invocationParams) {
            if (!serviceImplParams[i].getType().equals(invocationParam.getType())) {
                return false;
            }
            ++i;
        }
        for (int j = i; j < serviceImplParams.length; ++j) {
            if (serviceImplParams[j].isAnnotationPresent(Named.class) || !this.registry.lookupAllByType(serviceImplParams[j].getType()).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static Service createInjectProviderParamsServiceProxy(Service service, Registry registry) {
        Preconditions.checkArgument(service != null, "service cannot be null");
        Preconditions.checkArgument(registry != null, "registry cannot be null");
        InjectParamsFromContextServiceProxy handler = new InjectParamsFromContextServiceProxy(service, registry);
        return (Service)Proxy.newProxyInstance(service.getClass().getClassLoader(), ClassUtils.findImplementedInterfaces(service.getClass()), (InvocationHandler)handler);
    }
}

