/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.mule.runtime.config.internal.XmlMetadataAnnotationsFactory;
import org.mule.runtime.config.internal.parsers.DefaultXmlMetadataAnnotations;
import org.mule.runtime.config.internal.parsers.XmlMetadataAnnotations;
import org.mule.runtime.core.api.util.xmlsecurity.XMLSecureFactories;
import org.springframework.AAA.beans.factory.xml.DefaultDocumentLoader;
import org.springframework.AAA.beans.factory.xml.DocumentLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class MuleDocumentLoader
implements DocumentLoader {
    private static final UserDataHandler COPY_METADATA_ANNOTATIONS_DATA_HANDLER = new UserDataHandler(){

        @Override
        public void handle(short operation, String key, Object data, Node src, Node dst) {
            if (operation == 2 || operation == 1) {
                dst.setUserData("metadataAnnotations", src.getUserData("metadataAnnotations"), this);
            }
        }
    };
    private final DocumentLoader defaultLoader = new DefaultDocumentLoader();
    private final XmlMetadataAnnotationsFactory metadataFactory = new DefaultXmlMetadataFactory();

    @Override
    public Document loadDocument(InputSource inputSource, EntityResolver entityResolver, ErrorHandler errorHandler, int validationMode, boolean namespaceAware) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (InputStream inputStream = inputSource.getByteStream();){
            IOUtils.copy((InputStream)inputStream, (OutputStream)output);
        }
        InputSource defaultInputSource = new InputSource(new ByteArrayInputStream(output.toByteArray()));
        InputSource enrichInputSource = new InputSource(new ByteArrayInputStream(output.toByteArray()));
        Document doc = this.defaultLoader.loadDocument(defaultInputSource, entityResolver, errorHandler, validationMode, namespaceAware);
        this.createSaxAnnotator(doc).parse(enrichInputSource);
        return doc;
    }

    protected XMLReader createSaxAnnotator(Document doc) throws ParserConfigurationException, SAXException {
        SAXParserFactory saxParserFactory = XMLSecureFactories.createDefault().getSAXParserFactory();
        SAXParser saxParser = saxParserFactory.newSAXParser();
        XMLReader documentReader = saxParser.getXMLReader();
        documentReader.setContentHandler(new XmlMetadataAnnotator(doc, this.metadataFactory));
        return documentReader;
    }

    private static final class DomWalkerElement {
        private final DomWalkerElement parent;
        private final Node node;
        private int childIndex = 0;

        public DomWalkerElement(Node node) {
            this.parent = null;
            this.node = node;
        }

        private DomWalkerElement(DomWalkerElement parent, Node node) {
            this.parent = parent;
            this.node = node;
        }

        public DomWalkerElement walkIn() {
            Node nextChild = this.node.getChildNodes().item(this.childIndex++);
            while (nextChild != null && nextChild.getNodeType() != 1) {
                nextChild = this.node.getChildNodes().item(this.childIndex++);
            }
            return new DomWalkerElement(this, nextChild);
        }

        public DomWalkerElement walkOut() {
            Node nextSibling;
            for (nextSibling = this.parent.node.getNextSibling(); nextSibling != null && nextSibling.getNodeType() != 1; nextSibling = nextSibling.getNextSibling()) {
            }
            return new DomWalkerElement(this.parent.parent, nextSibling);
        }

        public Node getParentNode() {
            return this.parent.node;
        }
    }

    public static final class XmlMetadataAnnotator
    extends DefaultHandler {
        private Locator locator;
        private DomWalkerElement walker;
        private XmlMetadataAnnotationsFactory metadataFactory;
        private Stack<XmlMetadataAnnotations> annotationsStack = new Stack();

        private XmlMetadataAnnotator(Document doc, XmlMetadataAnnotationsFactory metadataFactory) {
            this.walker = new DomWalkerElement(doc.getDocumentElement());
            this.metadataFactory = metadataFactory;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            super.setDocumentLocator(locator);
            this.locator = locator;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.walker = this.walker.walkIn();
            XmlMetadataAnnotations metadataBuilder = this.metadataFactory.create(this.locator);
            LinkedHashMap<String, String> attsMap = new LinkedHashMap<String, String>();
            for (int i = 0; i < atts.getLength(); ++i) {
                attsMap.put(atts.getQName(i), atts.getValue(i));
            }
            metadataBuilder.appendElementStart(qName, attsMap);
            this.annotationsStack.push(metadataBuilder);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.annotationsStack.peek().appendElementBody(new String(ch, start, length).trim());
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            XmlMetadataAnnotations metadataAnnotations = this.annotationsStack.pop();
            metadataAnnotations.appendElementEnd(qName);
            if (!this.annotationsStack.isEmpty()) {
                this.annotationsStack.peek().appendElementBody(SystemUtils.LINE_SEPARATOR + metadataAnnotations.getElementString() + SystemUtils.LINE_SEPARATOR);
            }
            this.walker.getParentNode().setUserData("metadataAnnotations", metadataAnnotations, COPY_METADATA_ANNOTATIONS_DATA_HANDLER);
            this.walker = this.walker.walkOut();
        }
    }

    private final class DefaultXmlMetadataFactory
    implements XmlMetadataAnnotationsFactory {
        private DefaultXmlMetadataFactory() {
        }

        @Override
        public XmlMetadataAnnotations create(Locator locator) {
            DefaultXmlMetadataAnnotations annotations = new DefaultXmlMetadataAnnotations();
            annotations.setLineNumber(locator.getLineNumber());
            return annotations;
        }
    }
}

