/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.core.api.util.StringUtils;
import org.springframework.AAA.beans.BeansException;
import org.springframework.AAA.beans.factory.config.BeanPostProcessor;

public class TrackingPostProcessor
implements BeanPostProcessor {
    private List<String> trackingList = new ArrayList<String>();
    private boolean tracking = false;

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.tracking) {
            StringUtils.ifNotBlank(beanName, value -> {
                if (!this.trackingList.contains(value)) {
                    this.trackingList.add((String)value);
                }
            });
        }
        return bean;
    }

    public List<String> getBeansTracked() {
        return ImmutableList.copyOf(this.trackingList);
    }

    public void startTracking() {
        this.tracking = true;
        this.trackingList.clear();
    }

    public void stopTracking() {
        this.tracking = false;
    }

    public void intersection(List<String> beanNames) {
        this.trackingList.removeIf(name -> !beanNames.contains(name));
    }
}

