/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import org.mule.runtime.api.util.Preconditions;
import org.springframework.AAA.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.AAA.beans.factory.support.ManagedList;
import org.springframework.AAA.beans.factory.support.ManagedMap;

class BeanDefinitionBuilderHelper {
    public BeanDefinitionBuilder beanDefinitionBuilder;

    public BeanDefinitionBuilderHelper(BeanDefinitionBuilder beanDefinitionBuilder) {
        this.beanDefinitionBuilder = beanDefinitionBuilder;
    }

    public void addConstructorValue(Object value) {
        this.beanDefinitionBuilder.addConstructorArgValue(value);
    }

    public BeanDefinitionPropertyHelper forProperty(String propertyName) {
        return new BeanDefinitionPropertyHelper(propertyName);
    }

    public boolean hasValueForProperty(String propertyName) {
        return this.beanDefinitionBuilder.getBeanDefinition().getPropertyValues().contains(propertyName);
    }

    class BeanDefinitionPropertyHelper {
        private String propertyName;

        private BeanDefinitionPropertyHelper(String propertyName) {
            Preconditions.checkArgument(propertyName != null, "propertyName must be not null");
            this.propertyName = propertyName;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public void addReference(String reference) {
            BeanDefinitionBuilderHelper.this.beanDefinitionBuilder.addPropertyReference(this.propertyName, reference);
        }

        public void addValue(Object value) {
            if (!this.isEmpty(value)) {
                BeanDefinitionBuilderHelper.this.beanDefinitionBuilder.addPropertyValue(this.propertyName, value);
            }
        }

        private boolean isEmpty(Object value) {
            return value == null || value instanceof ManagedList && ((ManagedList)value).isEmpty() || value instanceof ManagedMap && ((ManagedMap)value).isEmpty();
        }
    }
}

