/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemUtils {
    protected static final Logger logger = LoggerFactory.getLogger(SystemUtils.class);
    private static Map environment = null;

    public static synchronized Map getenv() {
        if (environment == null) {
            try {
                environment = System.getenv();
            }
            catch (Exception ex) {
                logger.error("Could not access OS environment: ", (Throwable)ex);
                environment = Collections.EMPTY_MAP;
            }
        }
        return environment;
    }

    public static String getenv(String name) {
        return (String)SystemUtils.getenv().get(name);
    }

    public static boolean isSunJDK() {
        return org.apache.commons.lang3.SystemUtils.JAVA_VM_VENDOR.toUpperCase().indexOf("SUN") != -1 || org.apache.commons.lang3.SystemUtils.JAVA_VM_VENDOR.toUpperCase().indexOf("ORACLE") != -1;
    }

    public static boolean isAppleJDK() {
        return org.apache.commons.lang3.SystemUtils.JAVA_VM_VENDOR.toUpperCase().indexOf("APPLE") != -1;
    }

    public static boolean isIbmJDK() {
        return org.apache.commons.lang3.SystemUtils.JAVA_VM_VENDOR.toUpperCase().indexOf("IBM") != -1;
    }

    private static CommandLine parseCommandLine(String[] args, String[][] opts) throws MuleException {
        Options options = new Options();
        for (String[] opt : opts) {
            options.addOption(opt[0], opt[1].equals("true"), opt[2]);
        }
        BasicParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(options, args, true);
            if (line == null) {
                throw new DefaultMuleException("Unknown error parsing the Mule command line");
            }
            return line;
        }
        catch (ParseException p) {
            throw new DefaultMuleException("Unable to parse the Mule command line because of: " + p.toString(), (Throwable)p);
        }
    }

    public static Map<String, Object> getCommandLineOptions(String[] args, String[][] opts) throws MuleException {
        Option[] options;
        CommandLine line = SystemUtils.parseCommandLine(args, opts);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (Option option : options = line.getOptions()) {
            ret.put(option.getOpt(), option.getValue("true"));
        }
        return ret;
    }

    public static Map<String, String> parsePropertyDefinitions(String input) {
        if (StringUtils.isEmpty(input)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        int tokenStart = 0;
        while (tokenStart < input.length() && (tokenStart = org.apache.commons.lang3.StringUtils.indexOf((CharSequence)input, (CharSequence)"-D", (int)tokenStart)) != -1) {
            int keyEnd;
            int keyStart;
            if (keyStart == input.length()) break;
            char cursor = input.charAt(keyStart);
            if (cursor == ' ') continue;
            if (cursor == '=') {
                if ((tokenStart = org.apache.commons.lang3.StringUtils.indexOf((CharSequence)input, (int)32, (int)tokenStart)) == -1) break;
                continue;
            }
            for (keyEnd = keyStart = (tokenStart += 2); keyEnd < input.length(); ++keyEnd) {
                cursor = input.charAt(keyEnd);
                if (cursor == ' ') {
                    tokenStart = keyEnd;
                    break;
                }
                if (cursor == '=') break;
            }
            String key = org.apache.commons.lang3.StringUtils.substring((String)input, (int)keyStart, (int)keyEnd);
            int valueStart = keyEnd;
            int valueEnd = keyEnd;
            String value = "true";
            if (keyEnd < input.length() && cursor != ' ') {
                valueEnd = valueStart = keyEnd + 1;
                cursor = input.charAt(valueStart);
                valueEnd = cursor == '\"' ? org.apache.commons.lang3.StringUtils.indexOf((CharSequence)input, (int)34, (int)(++valueStart)) : org.apache.commons.lang3.StringUtils.indexOf((CharSequence)input, (int)32, (int)valueStart);
                if (valueEnd == -1) {
                    valueEnd = input.length();
                }
                value = org.apache.commons.lang3.StringUtils.substring((String)input, (int)valueStart, (int)valueEnd);
            }
            result.put(key, value);
            tokenStart = valueEnd;
        }
        return result;
    }

    public static Charset getDefaultEncoding(MuleContext muleContext) {
        if (muleContext != null && muleContext.getConfiguration().getDefaultEncoding() != null) {
            return Charset.forName(muleContext.getConfiguration().getDefaultEncoding());
        }
        if (System.getProperty("mule.encoding") != null) {
            return Charset.forName(System.getProperty("mule.encoding"));
        }
        return Charset.defaultCharset();
    }
}

