/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.policy.PolicyStateHandler;
import org.mule.runtime.core.api.policy.PolicyStateId;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.event.BaseEventContext;

public class DefaultPolicyStateHandler
implements PolicyStateHandler {
    protected Multimap<String, PolicyStateId> policyStateIdsByExecutionIdentifier = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    protected Map<PolicyStateId, CoreEvent> stateMap = new ConcurrentHashMap<PolicyStateId, CoreEvent>();
    protected Map<String, Processor> nextOperationMap = new ConcurrentHashMap<String, Processor>();

    @Override
    public void updateNextOperation(String identifier, Processor nextOperation) {
        this.nextOperationMap.put(identifier, nextOperation);
    }

    @Override
    public Processor retrieveNextOperation(String identifier) {
        return this.nextOperationMap.get(identifier);
    }

    @Override
    public Optional<CoreEvent> getLatestState(PolicyStateId identifier) {
        return Optional.ofNullable(this.stateMap.get(identifier));
    }

    @Override
    public void updateState(PolicyStateId identifier, CoreEvent lastStateEvent) {
        ((BaseEventContext)lastStateEvent.getContext()).getRootContext().onTerminated((response, throwable) -> this.destroyState(identifier.getExecutionIdentifier()));
        this.stateMap.put(identifier, lastStateEvent);
        this.policyStateIdsByExecutionIdentifier.put((Object)identifier.getExecutionIdentifier(), (Object)identifier);
    }

    @Override
    public void destroyState(String identifier) {
        Collection policyStateIds = this.policyStateIdsByExecutionIdentifier.get((Object)identifier);
        if (policyStateIds != null) {
            policyStateIds.stream().forEach(this.stateMap::remove);
        }
        this.policyStateIdsByExecutionIdentifier.removeAll((Object)identifier);
        this.nextOperationMap.remove(identifier);
    }
}

