/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.runtime.core.internal.streaming.DefaultMemoryManager;
import org.mule.runtime.core.internal.streaming.MemoryManager;
import org.mule.runtime.core.internal.streaming.bytes.MaxStreamingMemoryExceededException;
import org.mule.runtime.core.internal.util.ConcurrencyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolingByteBufferManager
implements ByteBufferManager,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoolingByteBufferManager.class);
    private static final int MAX_IDLE = Runtime.getRuntime().availableProcessors();
    private final AtomicLong streamingMemory = new AtomicLong(0L);
    private final long maxStreamingMemory;
    private final long waitTimeoutMillis;
    private final LoadingCache<Integer, BufferPool> pools = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).removalListener(notification -> {
        block2: {
            try {
                ((BufferPool)notification.getValue()).close();
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("Found exception trying to dispose buffer pool for capacity " + notification.getKey(), (Throwable)e);
            }
        }
    }).build((CacheLoader)new CacheLoader<Integer, BufferPool>(){

        public BufferPool load(Integer capacity) throws Exception {
            return new BufferPool(capacity);
        }
    });

    public PoolingByteBufferManager() {
        this(new DefaultMemoryManager(), 4000L);
    }

    public PoolingByteBufferManager(MemoryManager memoryManager, long waitTimeoutMillis) {
        this.maxStreamingMemory = this.calculateMaxStreamingMemory(memoryManager);
        this.waitTimeoutMillis = waitTimeoutMillis;
    }

    private long calculateMaxStreamingMemory(MemoryManager memoryManager) {
        String maxMemoryProperty = System.getProperty("mule.max.streaming.memory");
        if (maxMemoryProperty == null) {
            return Math.round((double)memoryManager.getMaxMemory() * 0.5);
        }
        try {
            return Long.valueOf(maxMemoryProperty);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Invalid value for system property '%s'. A memory size (in bytes) was expected, got '%s' instead", "mule.max.streaming.memory", maxMemoryProperty));
        }
    }

    @Override
    public ByteBuffer allocate(int capacity) {
        try {
            return ((BufferPool)this.pools.getUnchecked((Object)capacity)).take();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not allocate byte buffer. " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void deallocate(ByteBuffer byteBuffer) {
        int capacity = byteBuffer.capacity();
        BufferPool pool = (BufferPool)this.pools.getIfPresent((Object)capacity);
        if (pool != null) {
            try {
                pool.returnBuffer(byteBuffer);
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not deallocate buffer of capacity " + capacity), (Throwable)e);
            }
        }
    }

    @Override
    public void dispose() {
        block2: {
            try {
                this.pools.invalidateAll();
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn("Error disposing pool of byte buffers", (Throwable)e);
            }
        }
    }

    private class BufferPool {
        private final int bufferCapacity;
        private final ObjectPool<ByteBuffer> pool;
        private final Lock lock = new ReentrantLock();
        private final Condition poolNotFull = this.lock.newCondition();

        private BufferPool(final int bufferCapacity) {
            this.bufferCapacity = bufferCapacity;
            GenericObjectPoolConfig config = new GenericObjectPoolConfig();
            config.setMaxIdle(MAX_IDLE);
            config.setMaxTotal(-1);
            config.setBlockWhenExhausted(false);
            config.setTimeBetweenEvictionRunsMillis(TimeUnit.SECONDS.toMillis(30L));
            config.setTestOnBorrow(false);
            config.setTestOnReturn(false);
            config.setTestWhileIdle(false);
            config.setTestOnCreate(false);
            config.setJmxEnabled(false);
            this.pool = new GenericObjectPool<ByteBuffer>(new BasePooledObjectFactory<ByteBuffer>(){

                @Override
                public ByteBuffer create() throws Exception {
                    if (PoolingByteBufferManager.this.streamingMemory.addAndGet(bufferCapacity) <= PoolingByteBufferManager.this.maxStreamingMemory) {
                        return ByteBuffer.allocate(bufferCapacity);
                    }
                    PoolingByteBufferManager.this.streamingMemory.addAndGet(-bufferCapacity);
                    throw new MaxStreamingMemoryExceededException(I18nMessageFactory.createStaticMessage(String.format("Max streaming memory limit of %d bytes was exceeded", PoolingByteBufferManager.this.maxStreamingMemory)));
                }

                @Override
                public PooledObject<ByteBuffer> wrap(ByteBuffer obj) {
                    return new DefaultPooledObject<ByteBuffer>(obj);
                }

                @Override
                public void activateObject(PooledObject<ByteBuffer> p) throws Exception {
                    p.getObject().clear();
                }

                @Override
                public void destroyObject(PooledObject<ByteBuffer> p) throws Exception {
                    if (PoolingByteBufferManager.this.streamingMemory.addAndGet(-bufferCapacity) < PoolingByteBufferManager.this.maxStreamingMemory) {
                        BufferPool.this.signalPoolNotFull();
                    }
                }
            }, config);
        }

        private ByteBuffer take() throws Exception {
            ByteBuffer buffer = null;
            do {
                try {
                    buffer = this.pool.borrowObject();
                }
                catch (MaxStreamingMemoryExceededException e) {
                    this.signal(() -> {
                        while (PoolingByteBufferManager.this.streamingMemory.get() >= PoolingByteBufferManager.this.maxStreamingMemory) {
                            if (this.poolNotFull.await(PoolingByteBufferManager.this.waitTimeoutMillis, TimeUnit.MILLISECONDS)) continue;
                            throw e;
                        }
                    });
                }
            } while (buffer == null);
            return buffer;
        }

        private void returnBuffer(ByteBuffer buffer) throws Exception {
            this.pool.returnObject(buffer);
            this.signalPoolNotFull();
        }

        private void signalPoolNotFull() {
            this.signal(this.poolNotFull::signal);
        }

        private void close() {
            PoolingByteBufferManager.this.streamingMemory.addAndGet(-this.bufferCapacity * (this.pool.getNumActive() + this.pool.getNumIdle()));
            try {
                this.pool.close();
            }
            finally {
                this.signal(this.poolNotFull::signalAll);
            }
        }

        private void signal(CheckedRunnable task) {
            ConcurrencyUtils.withLock(this.lock, task);
        }
    }
}

