/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.handler.DefaultObjectFieldHandler;
import org.mule.metadata.java.api.handler.ObjectFieldHandler;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.ConfigReferences;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.ExclusiveOptionals;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.Query;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.display.Text;
import org.mule.runtime.extension.api.annotation.param.reference.ConfigReference;
import org.mule.runtime.extension.api.annotation.param.reference.FlowReference;
import org.mule.runtime.extension.api.annotation.param.reference.ObjectStoreReference;
import org.mule.runtime.extension.api.declaration.type.TypeUtils;
import org.mule.runtime.extension.api.declaration.type.annotation.ConfigOverrideTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.DefaultImplementingTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.DisplayTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ExclusiveOptionalsTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ExpressionSupportAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.LayoutTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.NullSafeTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ParameterDslAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;

final class ExtensionsObjectFieldHandler
implements ObjectFieldHandler {
    ExtensionsObjectFieldHandler() {
    }

    @Override
    public void handleFields(Class<?> clazz, TypeHandlerManager typeHandlerManager, ParsingContext context, ObjectTypeBuilder builder) {
        if (clazz.getName().equals(Chain.class.getName())) {
            return;
        }
        Collection<Field> fields = TypeUtils.getParameterFields(clazz);
        if (fields.isEmpty()) {
            this.validateIllegalAnnotationUseOnNonParameterFields(clazz);
            this.fallbackToBeanProperties(clazz, typeHandlerManager, context, builder);
            return;
        }
        for (Field field : fields) {
            ObjectFieldTypeBuilder fieldBuilder = builder.addField();
            fieldBuilder.key(TypeUtils.getAlias(field));
            this.setOptionalAndDefault(field, fieldBuilder);
            this.processParameterGroup(field, fieldBuilder);
            this.processExpressionSupport(field, fieldBuilder);
            this.processNullSafe(clazz, field, fieldBuilder, typeHandlerManager, context);
            this.processElementStyle(field, fieldBuilder);
            this.processLayoutAnnotation(field, fieldBuilder);
            this.processDisplayAnnotation(field, fieldBuilder);
            this.processConfigOverride(field, fieldBuilder);
            this.processElementReference(field, fieldBuilder);
            this.setFieldType(typeHandlerManager, context, field, fieldBuilder);
        }
    }

    private void validateIllegalAnnotationUseOnNonParameterFields(Class<?> clazz) {
        String annotationsPackageName = Parameter.class.getPackage().getName();
        List illegalFieldNames = TypeUtils.getAllFields(clazz).stream().filter(field -> Stream.of(field.getAnnotations()).anyMatch(a -> a.annotationType().getName().contains(annotationsPackageName))).map(Field::getName).collect(Collectors.toList());
        if (!illegalFieldNames.isEmpty()) {
            throw new IllegalModelDefinitionException(String.format("Class '%s' has fields which are not parameters but are annotated with Extensions API annotations. Illegal fields are " + illegalFieldNames, clazz.getName()));
        }
    }

    private void processParameterGroup(Field field, ObjectFieldTypeBuilder fieldBuilder) {
        if (field.getAnnotation(ParameterGroup.class) != null) {
            fieldBuilder.with(new FlattenedTypeAnnotation());
            this.processExclusiveOptionals(field, fieldBuilder);
        }
    }

    private void processExclusiveOptionals(Field field, ObjectFieldTypeBuilder fieldBuilder) {
        ExclusiveOptionals exclusiveOptionals = field.getType().getAnnotation(ExclusiveOptionals.class);
        if (exclusiveOptionals != null) {
            Set exclusiveParameters = TypeUtils.getParameterFields(field.getType()).stream().filter(f -> f.isAnnotationPresent(org.mule.runtime.extension.api.annotation.param.Optional.class)).map(f -> f.getAnnotation(Alias.class) != null ? f.getAnnotation(Alias.class).value() : f.getName()).collect(Collectors.toCollection(LinkedHashSet::new));
            fieldBuilder.with(new ExclusiveOptionalsTypeAnnotation(exclusiveParameters, exclusiveOptionals.isOneRequired()));
        }
    }

    private void processDisplayAnnotation(Field field, ObjectFieldTypeBuilder fieldBuilder) {
        Path path;
        DisplayModel.DisplayModelBuilder builder = DisplayModel.builder();
        boolean shouldAddTypeAnnotation = false;
        if (field.getAnnotation(DisplayName.class) != null) {
            builder.displayName(field.getAnnotation(DisplayName.class).value());
            shouldAddTypeAnnotation = true;
        }
        if (field.getAnnotation(Summary.class) != null) {
            builder.summary(field.getAnnotation(Summary.class).value());
            shouldAddTypeAnnotation = true;
        }
        if (field.getAnnotation(Example.class) != null) {
            builder.example(field.getAnnotation(Example.class).value());
            shouldAddTypeAnnotation = true;
        }
        if ((path = field.getAnnotation(Path.class)) != null) {
            builder.path(new PathModel(path.type(), path.acceptsUrls(), path.location(), path.acceptedFileExtensions()));
            shouldAddTypeAnnotation = true;
        }
        if (shouldAddTypeAnnotation) {
            fieldBuilder.with(new DisplayTypeAnnotation(builder.build()));
        }
    }

    private void processLayoutAnnotation(Field field, ObjectFieldTypeBuilder fieldBuilder) {
        LayoutModel.LayoutModelBuilder builder = LayoutModel.builder();
        boolean shouldAddTypeAnnotation = false;
        Placement placement = field.getAnnotation(Placement.class);
        if (placement != null) {
            builder.tabName(placement.tab()).order(placement.order());
            shouldAddTypeAnnotation = true;
        }
        if (field.getAnnotation(Password.class) != null) {
            builder.asPassword();
            shouldAddTypeAnnotation = true;
        }
        if (field.getAnnotation(Text.class) != null) {
            builder.asText();
            shouldAddTypeAnnotation = true;
        }
        if (field.getAnnotation(Query.class) != null) {
            builder.asQuery();
            shouldAddTypeAnnotation = true;
        }
        if (shouldAddTypeAnnotation) {
            fieldBuilder.with(new LayoutTypeAnnotation(builder.build()));
        }
    }

    private void setFieldType(TypeHandlerManager typeHandlerManager, ParsingContext context, Field field, ObjectFieldTypeBuilder fieldBuilder) {
        Type fieldType = field.getGenericType();
        Optional<TypeBuilder<?>> typeBuilder = context.getTypeBuilder(fieldType);
        if (typeBuilder.isPresent()) {
            fieldBuilder.value(typeBuilder.get());
        } else {
            typeHandlerManager.handle(fieldType, context, fieldBuilder.value());
        }
    }

    private void processExpressionSupport(Field field, ObjectFieldTypeBuilder fieldBuilder) {
        Expression expression = field.getAnnotation(Expression.class);
        fieldBuilder.with(new ExpressionSupportAnnotation(expression != null ? expression.value() : ExpressionSupport.SUPPORTED));
    }

    private void processNullSafe(Class<?> declaringClass, Field field, ObjectFieldTypeBuilder fieldBuilder, TypeHandlerManager typeHandlerManager, ParsingContext context) {
        NullSafe nullSafe = field.getAnnotation(NullSafe.class);
        if (nullSafe == null) {
            return;
        }
        boolean isOptional = field.isAnnotationPresent(org.mule.runtime.extension.api.annotation.param.Optional.class);
        boolean isParameterGroup = field.isAnnotationPresent(ParameterGroup.class);
        if (!isOptional && !isParameterGroup) {
            throw new IllegalParameterModelDefinitionException(String.format("Field '%s' in class '%s' is required but annotated with '@%s', which is redundant", field.getName(), declaringClass.getName(), NullSafe.class.getSimpleName()));
        }
        Class<?> defaultType = nullSafe.defaultImplementingType();
        if (defaultType.equals(Object.class)) {
            fieldBuilder.with(new NullSafeTypeAnnotation(field.getType(), false));
        } else {
            fieldBuilder.with(new NullSafeTypeAnnotation(defaultType, true));
            Optional<TypeBuilder<?>> typeBuilder = context.getTypeBuilder(defaultType);
            if (typeBuilder.isPresent()) {
                fieldBuilder.with(new DefaultImplementingTypeAnnotation((MetadataType)typeBuilder.get().build()));
            } else {
                BaseTypeBuilder defaultTypeBuilder = BaseTypeBuilder.create(MetadataFormat.JAVA);
                typeHandlerManager.handle(defaultType, context, defaultTypeBuilder);
                fieldBuilder.with(new DefaultImplementingTypeAnnotation(defaultTypeBuilder.build()));
            }
        }
    }

    private void processConfigOverride(Field field, ObjectFieldTypeBuilder fieldBuilder) {
        ConfigOverride override = field.getAnnotation(ConfigOverride.class);
        if (override != null) {
            fieldBuilder.required(false);
            fieldBuilder.with(new ConfigOverrideTypeAnnotation());
        }
    }

    private void processElementReference(Field field, ObjectFieldTypeBuilder fieldBuilder) {
        ConfigReference ref2;
        ConfigReferences references = field.getAnnotation(ConfigReferences.class);
        if (references != null) {
            Arrays.stream(references.value()).map(ref -> new StereotypeTypeAnnotation(Collections.singletonList(StereotypeModelBuilder.newStereotype(ref.name(), ref.namespace()).withParent(MuleStereotypes.CONFIG).build()))).forEach(fieldBuilder::with);
        }
        if ((ref2 = field.getAnnotation(ConfigReference.class)) != null) {
            fieldBuilder.with(new StereotypeTypeAnnotation(Collections.singletonList(StereotypeModelBuilder.newStereotype(ref2.name(), ref2.namespace()).withParent(MuleStereotypes.CONFIG).build())));
        }
        if (field.getAnnotation(FlowReference.class) != null) {
            fieldBuilder.with(new StereotypeTypeAnnotation(Collections.singletonList(MuleStereotypes.FLOW)));
        }
        if (field.getAnnotation(ObjectStoreReference.class) != null) {
            fieldBuilder.with(new StereotypeTypeAnnotation(Collections.singletonList(MuleStereotypes.OBJECT_STORE)));
        }
    }

    private void processElementStyle(Field field, ObjectFieldTypeBuilder fieldBuilder) {
        ParameterDsl annotation = field.getAnnotation(ParameterDsl.class);
        if (annotation != null) {
            fieldBuilder.with(new ParameterDslAnnotation(annotation.allowInlineDefinition(), annotation.allowReferences()));
        }
    }

    private void setOptionalAndDefault(Field field, ObjectFieldTypeBuilder fieldBuilder) {
        Optional<Content> contentAnnotation = Optional.ofNullable(field.getAnnotation(Content.class));
        Optional<org.mule.runtime.extension.api.annotation.param.Optional> optionalAnnotation = Optional.ofNullable(field.getAnnotation(org.mule.runtime.extension.api.annotation.param.Optional.class));
        fieldBuilder.required(true);
        contentAnnotation.ifPresent(content -> {
            if (content.primary()) {
                fieldBuilder.required(false);
                if (ExtensionModelUtils.getDefaultValue(field) == null) {
                    fieldBuilder.with(new DefaultValueAnnotation("#[payload]"));
                }
            }
        });
        optionalAnnotation.ifPresent(optional -> {
            fieldBuilder.required(false);
            if (ExtensionModelUtils.getDefaultValue(optional) != null) {
                fieldBuilder.with(new DefaultValueAnnotation(optional.defaultValue()));
            }
        });
        if (Boolean.class.isAssignableFrom(field.getType()) || Boolean.TYPE.isAssignableFrom(field.getType())) {
            fieldBuilder.required(false);
            if (ExtensionModelUtils.getDefaultValue(field) == null && field.getAnnotation(ConfigOverride.class) == null) {
                fieldBuilder.with(new DefaultValueAnnotation(String.valueOf(Boolean.FALSE)));
            }
        }
    }

    private void fallbackToBeanProperties(Class<?> clazz, TypeHandlerManager typeHandlerManager, ParsingContext context, ObjectTypeBuilder builder) {
        if (!clazz.isInterface()) {
            new DefaultObjectFieldHandler().handleFields(clazz, typeHandlerManager, context, builder);
        }
    }
}

