/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.app.declaration.serialization.adapter;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConstructElementDeclaration;
import org.mule.runtime.app.declaration.api.OperationElementDeclaration;
import org.mule.runtime.app.declaration.api.RouteElementDeclaration;
import org.mule.runtime.app.declaration.api.SourceElementDeclaration;
import org.mule.runtime.app.declaration.api.fluent.BaseElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ComponentElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.HasNestedComponentDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ParameterizedElementDeclarer;
import org.mule.runtime.internal.app.declaration.serialization.adapter.ElementDeclarationSerializationUtils;

class ComponentElementDeclarationTypeAdapter
extends TypeAdapter<ComponentElementDeclaration> {
    private final Gson delegate;

    ComponentElementDeclarationTypeAdapter(Gson delegate) {
        this.delegate = delegate;
    }

    public void write(JsonWriter out, ComponentElementDeclaration value) throws IOException {
        out.beginObject();
        ElementDeclarationSerializationUtils.populateParameterizedObject(this.delegate, out, value, this.getKind(value));
        if (value.getConfigRef() != null && !value.getConfigRef().trim().isEmpty()) {
            out.name("configRef").value(value.getConfigRef());
        }
        out.name("components").jsonValue(this.delegate.toJson(value.getComponents()));
        out.endObject();
    }

    public ComponentElementDeclaration read(JsonReader in) throws IOException {
        JsonElement parse = new JsonParser().parse(in);
        if (parse.isJsonObject()) {
            JsonObject jsonObject = parse.getAsJsonObject();
            JsonElement elementKind = jsonObject.get("kind");
            JsonElement elementExtension = jsonObject.get("declaringExtension");
            JsonElement elementName = jsonObject.get("name");
            if (elementKind != null && elementExtension != null && elementName != null) {
                JsonElement configRef;
                Object declarer = this.getDeclarer(ElementDeclarer.forExtension(elementExtension.getAsString()), elementKind.getAsString(), elementName.getAsString());
                ElementDeclarationSerializationUtils.declareParameterizedElement(this.delegate, jsonObject, declarer);
                if (declarer instanceof HasNestedComponentDeclarer) {
                    ElementDeclarationSerializationUtils.declareComposableElement(this.delegate, jsonObject, (HasNestedComponentDeclarer)declarer);
                }
                if ((configRef = jsonObject.get("configRef")) != null && declarer instanceof ComponentElementDeclarer) {
                    ((ComponentElementDeclarer)declarer).withConfig(configRef.getAsString());
                }
                return (ComponentElementDeclaration)((BaseElementDeclarer)declarer).getDeclaration();
            }
        }
        return null;
    }

    private <T extends ParameterizedElementDeclarer> T getDeclarer(ElementDeclarer declarer, String kind, String name) {
        switch (kind) {
            case "OPERATION": {
                return (T)declarer.newOperation(name);
            }
            case "SOURCE": {
                return (T)declarer.newSource(name);
            }
            case "CONSTRUCT": {
                return (T)declarer.newConstruct(name);
            }
            case "ROUTE": {
                return (T)declarer.newRoute(name);
            }
        }
        throw new IllegalArgumentException("Unknown kind: " + kind);
    }

    private String getKind(ComponentElementDeclaration type) {
        if (type instanceof OperationElementDeclaration) {
            return "OPERATION";
        }
        if (type instanceof SourceElementDeclaration) {
            return "SOURCE";
        }
        if (type instanceof ConstructElementDeclaration) {
            return "CONSTRUCT";
        }
        if (type instanceof RouteElementDeclaration) {
            return "ROUTE";
        }
        throw new IllegalArgumentException("Unknown kind for type: " + type.getName());
    }
}

