/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.beans;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.AAA.beans.BeanUtils;
import org.springframework.AAA.util.ObjectUtils;
import org.springframework.AAA.util.ReflectionUtils;
import org.springframework.AAA.util.StringUtils;

public abstract class PropertyMatches {
    public static final int DEFAULT_MAX_DISTANCE = 2;
    private final String propertyName;
    private String[] possibleMatches;

    public static PropertyMatches forProperty(String propertyName, Class<?> beanClass) {
        return PropertyMatches.forProperty(propertyName, beanClass, 2);
    }

    public static PropertyMatches forProperty(String propertyName, Class<?> beanClass, int maxDistance) {
        return new BeanPropertyMatches(propertyName, beanClass, maxDistance);
    }

    public static PropertyMatches forField(String propertyName, Class<?> beanClass) {
        return PropertyMatches.forField(propertyName, beanClass, 2);
    }

    public static PropertyMatches forField(String propertyName, Class<?> beanClass, int maxDistance) {
        return new FieldPropertyMatches(propertyName, beanClass, maxDistance);
    }

    private PropertyMatches(String propertyName, String[] possibleMatches) {
        this.propertyName = propertyName;
        this.possibleMatches = possibleMatches;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String[] getPossibleMatches() {
        return this.possibleMatches;
    }

    public abstract String buildErrorMessage();

    protected void appendHintMessage(StringBuilder msg) {
        msg.append("Did you mean ");
        for (int i = 0; i < this.possibleMatches.length; ++i) {
            msg.append('\'');
            msg.append(this.possibleMatches[i]);
            if (i < this.possibleMatches.length - 2) {
                msg.append("', ");
                continue;
            }
            if (i != this.possibleMatches.length - 2) continue;
            msg.append("', or ");
        }
        msg.append("'?");
    }

    private static int calculateStringDistance(String s1, String s2) {
        int i;
        if (s1.length() == 0) {
            return s2.length();
        }
        if (s2.length() == 0) {
            return s1.length();
        }
        int[][] d = new int[s1.length() + 1][s2.length() + 1];
        for (i = 0; i <= s1.length(); ++i) {
            d[i][0] = i;
        }
        for (int j = 0; j <= s2.length(); ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= s1.length(); ++i) {
            char s_i = s1.charAt(i - 1);
            for (int j = 1; j <= s2.length(); ++j) {
                char t_j = s2.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = Math.min(Math.min(d[i - 1][j] + 1, d[i][j - 1] + 1), d[i - 1][j - 1] + cost);
            }
        }
        return d[s1.length()][s2.length()];
    }

    private static class FieldPropertyMatches
    extends PropertyMatches {
        private FieldPropertyMatches(String propertyName, Class<?> beanClass, int maxDistance) {
            super(propertyName, FieldPropertyMatches.calculateMatches(propertyName, beanClass, maxDistance));
        }

        private static String[] calculateMatches(final String propertyName, Class<?> beanClass, final int maxDistance) {
            final ArrayList<String> candidates = new ArrayList<String>();
            ReflectionUtils.doWithFields(beanClass, new ReflectionUtils.FieldCallback(){

                @Override
                public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                    String possibleAlternative = field.getName();
                    if (PropertyMatches.calculateStringDistance(propertyName, possibleAlternative) <= maxDistance) {
                        candidates.add(possibleAlternative);
                    }
                }
            });
            Collections.sort(candidates);
            return StringUtils.toStringArray(candidates);
        }

        @Override
        public String buildErrorMessage() {
            String propertyName = this.getPropertyName();
            Object[] possibleMatches = this.getPossibleMatches();
            StringBuilder msg = new StringBuilder();
            msg.append("Bean property '");
            msg.append(propertyName);
            msg.append("' has no matching field. ");
            if (!ObjectUtils.isEmpty(possibleMatches)) {
                this.appendHintMessage(msg);
            }
            return msg.toString();
        }
    }

    private static class BeanPropertyMatches
    extends PropertyMatches {
        private BeanPropertyMatches(String propertyName, Class<?> beanClass, int maxDistance) {
            super(propertyName, BeanPropertyMatches.calculateMatches(propertyName, BeanUtils.getPropertyDescriptors(beanClass), maxDistance));
        }

        private static String[] calculateMatches(String propertyName, PropertyDescriptor[] propertyDescriptors, int maxDistance) {
            ArrayList<String> candidates = new ArrayList<String>();
            for (PropertyDescriptor pd : propertyDescriptors) {
                String possibleAlternative;
                if (pd.getWriteMethod() == null || PropertyMatches.calculateStringDistance(propertyName, possibleAlternative = pd.getName()) > maxDistance) continue;
                candidates.add(possibleAlternative);
            }
            Collections.sort(candidates);
            return StringUtils.toStringArray(candidates);
        }

        @Override
        public String buildErrorMessage() {
            String propertyName = this.getPropertyName();
            Object[] possibleMatches = this.getPossibleMatches();
            StringBuilder msg = new StringBuilder();
            msg.append("Bean property '");
            msg.append(propertyName);
            msg.append("' is not writable or has an invalid setter method. ");
            if (ObjectUtils.isEmpty(possibleMatches)) {
                msg.append("Does the parameter type of the setter match the return type of the getter?");
            } else {
                this.appendHintMessage(msg);
            }
            return msg.toString();
        }
    }
}

