/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.beans.factory.config;

import java.beans.PropertyEditor;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.AAA.beans.BeansException;
import org.springframework.AAA.beans.PropertyEditorRegistrar;
import org.springframework.AAA.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.AAA.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.AAA.core.Ordered;

public class CustomEditorConfigurer
implements BeanFactoryPostProcessor,
Ordered {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int order = Integer.MAX_VALUE;
    private PropertyEditorRegistrar[] propertyEditorRegistrars;
    private Map<Class<?>, Class<? extends PropertyEditor>> customEditors;

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setPropertyEditorRegistrars(PropertyEditorRegistrar[] propertyEditorRegistrars) {
        this.propertyEditorRegistrars = propertyEditorRegistrars;
    }

    public void setCustomEditors(Map<Class<?>, Class<? extends PropertyEditor>> customEditors) {
        this.customEditors = customEditors;
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.propertyEditorRegistrars != null) {
            for (PropertyEditorRegistrar propertyEditorRegistrar : this.propertyEditorRegistrars) {
                beanFactory.addPropertyEditorRegistrar(propertyEditorRegistrar);
            }
        }
        if (this.customEditors != null) {
            for (Map.Entry entry : this.customEditors.entrySet()) {
                Class requiredType = (Class)entry.getKey();
                Class propertyEditorClass = (Class)entry.getValue();
                beanFactory.registerCustomEditor(requiredType, propertyEditorClass);
            }
        }
    }
}

