/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.context.access;

import org.springframework.AAA.beans.factory.BeanFactory;
import org.springframework.AAA.beans.factory.access.BeanFactoryReference;
import org.springframework.AAA.context.ApplicationContext;
import org.springframework.AAA.context.ConfigurableApplicationContext;

public class ContextBeanFactoryReference
implements BeanFactoryReference {
    private ApplicationContext applicationContext;

    public ContextBeanFactoryReference(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public BeanFactory getFactory() {
        if (this.applicationContext == null) {
            throw new IllegalStateException("ApplicationContext owned by this BeanFactoryReference has been released");
        }
        return this.applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.applicationContext != null) {
            ApplicationContext savedCtx;
            ContextBeanFactoryReference contextBeanFactoryReference = this;
            synchronized (contextBeanFactoryReference) {
                savedCtx = this.applicationContext;
                this.applicationContext = null;
            }
            if (savedCtx != null && savedCtx instanceof ConfigurableApplicationContext) {
                ((ConfigurableApplicationContext)savedCtx).close();
            }
        }
    }
}

