/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.context.event;

import org.springframework.AAA.aop.support.AopUtils;
import org.springframework.AAA.context.ApplicationEvent;
import org.springframework.AAA.context.ApplicationListener;
import org.springframework.AAA.context.event.SmartApplicationListener;
import org.springframework.AAA.core.GenericTypeResolver;
import org.springframework.AAA.core.Ordered;
import org.springframework.AAA.util.Assert;

public class GenericApplicationListenerAdapter
implements SmartApplicationListener {
    private final ApplicationListener<ApplicationEvent> delegate;

    public GenericApplicationListenerAdapter(ApplicationListener<?> delegate) {
        Assert.notNull(delegate, "Delegate listener must not be null");
        this.delegate = delegate;
    }

    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        this.delegate.onApplicationEvent(event);
    }

    @Override
    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        Class<?> targetClass;
        Class<? extends ApplicationEvent> declaredEventType = GenericApplicationListenerAdapter.resolveDeclaredEventType(this.delegate.getClass());
        if ((declaredEventType == null || declaredEventType.equals(ApplicationEvent.class)) && (targetClass = AopUtils.getTargetClass(this.delegate)) != this.delegate.getClass()) {
            declaredEventType = GenericApplicationListenerAdapter.resolveDeclaredEventType(targetClass);
        }
        return declaredEventType == null || declaredEventType.isAssignableFrom(eventType);
    }

    @Override
    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    @Override
    public int getOrder() {
        return this.delegate instanceof Ordered ? ((Ordered)((Object)this.delegate)).getOrder() : Integer.MAX_VALUE;
    }

    static Class<?> resolveDeclaredEventType(Class<?> listenerType) {
        return GenericTypeResolver.resolveTypeArgument(listenerType, ApplicationListener.class);
    }
}

