/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.context.expression;

import org.springframework.AAA.beans.factory.BeanFactory;
import org.springframework.AAA.expression.AccessException;
import org.springframework.AAA.expression.EvaluationContext;
import org.springframework.AAA.expression.PropertyAccessor;
import org.springframework.AAA.expression.TypedValue;

public class BeanFactoryAccessor
implements PropertyAccessor {
    @Override
    public Class<?>[] getSpecificTargetClasses() {
        return new Class[]{BeanFactory.class};
    }

    @Override
    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        return ((BeanFactory)target).containsBean(name);
    }

    @Override
    public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
        return new TypedValue(((BeanFactory)target).getBean(name));
    }

    @Override
    public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
        return false;
    }

    @Override
    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        throw new AccessException("Beans in a BeanFactory are read-only");
    }
}

