/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.core.convert.support;

import java.util.Set;
import org.springframework.AAA.core.convert.converter.Converter;
import org.springframework.AAA.core.convert.converter.ConverterFactory;
import org.springframework.AAA.core.convert.converter.ConverterRegistry;
import org.springframework.AAA.core.convert.converter.GenericConverter;
import org.springframework.AAA.core.convert.support.DefaultConversionService;
import org.springframework.AAA.core.convert.support.GenericConversionService;

public abstract class ConversionServiceFactory {
    public static void registerConverters(Set<?> converters, ConverterRegistry registry) {
        if (converters != null) {
            for (Object converter : converters) {
                if (converter instanceof GenericConverter) {
                    registry.addConverter((GenericConverter)converter);
                    continue;
                }
                if (converter instanceof Converter) {
                    registry.addConverter((Converter)converter);
                    continue;
                }
                if (converter instanceof ConverterFactory) {
                    registry.addConverterFactory((ConverterFactory)converter);
                    continue;
                }
                throw new IllegalArgumentException("Each converter object must implement one of the Converter, ConverterFactory, or GenericConverter interfaces");
            }
        }
    }

    @Deprecated
    public static GenericConversionService createDefaultConversionService() {
        return new DefaultConversionService();
    }

    @Deprecated
    public static void addDefaultConverters(GenericConversionService conversionService) {
        DefaultConversionService.addDefaultConverters(conversionService);
    }
}

