/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.core.convert.support;

import org.springframework.AAA.core.convert.ConversionService;
import org.springframework.AAA.core.convert.TypeDescriptor;
import org.springframework.AAA.core.convert.converter.ConditionalConverter;
import org.springframework.AAA.core.convert.converter.Converter;
import org.springframework.AAA.util.ClassUtils;

final class EnumToStringConverter
implements Converter<Enum<?>, String>,
ConditionalConverter {
    private final ConversionService conversionService;

    public EnumToStringConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        for (Class<?> interfaceType : ClassUtils.getAllInterfacesForClass(sourceType.getType())) {
            if (!this.conversionService.canConvert(TypeDescriptor.valueOf(interfaceType), targetType)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String convert(Enum<?> source) {
        return source.name();
    }
}

