/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.expression.spel.ast;

import org.springframework.AAA.asm.MethodVisitor;
import org.springframework.AAA.expression.TypedValue;
import org.springframework.AAA.expression.spel.CodeFlow;
import org.springframework.AAA.expression.spel.ast.Literal;

public class IntLiteral
extends Literal {
    private final TypedValue value;

    IntLiteral(String payload, int pos, int value) {
        super(payload, pos);
        this.value = new TypedValue(value);
        this.exitTypeDescriptor = "I";
    }

    @Override
    public TypedValue getLiteralValue() {
        return this.value;
    }

    @Override
    public boolean isCompilable() {
        return true;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        int intValue = (Integer)this.value.getValue();
        if (intValue == -1) {
            mv.visitInsn(2);
        } else if (intValue >= 0 && intValue < 6) {
            mv.visitInsn(3 + intValue);
        } else {
            mv.visitLdcInsn(intValue);
        }
        cf.pushDescriptor(this.exitTypeDescriptor);
    }
}

