/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.AAA.expression.spel.support;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.springframework.AAA.core.MethodParameter;
import org.springframework.AAA.core.convert.TypeDescriptor;
import org.springframework.AAA.expression.AccessException;
import org.springframework.AAA.expression.ConstructorExecutor;
import org.springframework.AAA.expression.ConstructorResolver;
import org.springframework.AAA.expression.EvaluationContext;
import org.springframework.AAA.expression.EvaluationException;
import org.springframework.AAA.expression.TypeConverter;
import org.springframework.AAA.expression.spel.support.ReflectionHelper;
import org.springframework.AAA.expression.spel.support.ReflectiveConstructorExecutor;

public class ReflectiveConstructorResolver
implements ConstructorResolver {
    @Override
    public ConstructorExecutor resolve(EvaluationContext context, String typeName, List<TypeDescriptor> argumentTypes) throws AccessException {
        try {
            TypeConverter typeConverter = context.getTypeConverter();
            Class<?> type = context.getTypeLocator().findType(typeName);
            Constructor<?>[] ctors = type.getConstructors();
            Arrays.sort(ctors, new Comparator<Constructor<?>>(){

                @Override
                public int compare(Constructor<?> c1, Constructor<?> c2) {
                    int c2pl;
                    int c1pl = c1.getParameterTypes().length;
                    return c1pl < (c2pl = c2.getParameterTypes().length) ? -1 : (c1pl > c2pl ? 1 : 0);
                }
            });
            Constructor<?> closeMatch = null;
            Constructor<?> matchRequiringConversion = null;
            for (Constructor<?> ctor : ctors) {
                Class<?>[] paramTypes = ctor.getParameterTypes();
                ArrayList<TypeDescriptor> paramDescriptors = new ArrayList<TypeDescriptor>(paramTypes.length);
                for (int i = 0; i < paramTypes.length; ++i) {
                    paramDescriptors.add(new TypeDescriptor(new MethodParameter(ctor, i)));
                }
                ReflectionHelper.ArgumentsMatchInfo matchInfo = null;
                if (ctor.isVarArgs() && argumentTypes.size() >= paramTypes.length - 1) {
                    matchInfo = ReflectionHelper.compareArgumentsVarargs(paramDescriptors, argumentTypes, typeConverter);
                } else if (paramTypes.length == argumentTypes.size()) {
                    matchInfo = ReflectionHelper.compareArguments(paramDescriptors, argumentTypes, typeConverter);
                }
                if (matchInfo == null) continue;
                if (matchInfo.isExactMatch()) {
                    return new ReflectiveConstructorExecutor(ctor);
                }
                if (matchInfo.isCloseMatch()) {
                    closeMatch = ctor;
                    continue;
                }
                if (!matchInfo.isMatchRequiringConversion()) continue;
                matchRequiringConversion = ctor;
            }
            if (closeMatch != null) {
                return new ReflectiveConstructorExecutor(closeMatch);
            }
            if (matchRequiringConversion != null) {
                return new ReflectiveConstructorExecutor(matchRequiringConversion);
            }
            return null;
        }
        catch (EvaluationException ex) {
            throw new AccessException("Failed to resolve constructor", ex);
        }
    }
}

